package com.ejianc.business.rmat.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;


/**
 * 日租金报表
 *
 * @author generator
 *
 */
public class ReportDailyVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private String projectSourceId; // 项目来源ID
    private Long orgId; // 项目组织id
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织id
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private Long realCorpId;      // NC所属组织ID
    private String realNcCorp;    // NC所属组织PK
    private String realCorpName;  // NC所属组织名称
    private BigDecimal sumRentTaxMny; // 累计租赁金额
    private BigDecimal sumRentMny; // 累计租赁金额(无税)
    private BigDecimal sumScrapTaxMny; // 累计退赔金额
    private BigDecimal sumScrapMny; // 累计退赔金额(无税)
    private BigDecimal sumRepairTaxMny; // 累计维修金额
    private BigDecimal sumRepairMny; // 累计维修金额(无税)
    private BigDecimal sumOtherTaxMny; // 累计其他金额
    private BigDecimal sumOtherMny; // 累计其他金额(无税)
    private String memo; // 备注


    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    @ReferSerialTransfer(referCode="market-project")
    public Long getProjectId() {
        return projectId;
    }
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getOrgId() {
        return orgId;
    }
    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }
    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }

    public String getRealNcCorp() {
        return realNcCorp;
    }

    public void setRealNcCorp(String realNcCorp) {
        this.realNcCorp = realNcCorp;
    }

    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }

    public BigDecimal getSumRentTaxMny() {
        return sumRentTaxMny;
    }

    public void setSumRentTaxMny(BigDecimal sumRentTaxMny) {
        this.sumRentTaxMny = sumRentTaxMny;
    }
    public BigDecimal getSumRentMny() {
        return sumRentMny;
    }

    public void setSumRentMny(BigDecimal sumRentMny) {
        this.sumRentMny = sumRentMny;
    }
    public BigDecimal getSumScrapTaxMny() {
        return sumScrapTaxMny;
    }

    public void setSumScrapTaxMny(BigDecimal sumScrapTaxMny) {
        this.sumScrapTaxMny = sumScrapTaxMny;
    }
    public BigDecimal getSumScrapMny() {
        return sumScrapMny;
    }

    public void setSumScrapMny(BigDecimal sumScrapMny) {
        this.sumScrapMny = sumScrapMny;
    }
    public BigDecimal getSumRepairTaxMny() {
        return sumRepairTaxMny;
    }

    public void setSumRepairTaxMny(BigDecimal sumRepairTaxMny) {
        this.sumRepairTaxMny = sumRepairTaxMny;
    }
    public BigDecimal getSumRepairMny() {
        return sumRepairMny;
    }

    public void setSumRepairMny(BigDecimal sumRepairMny) {
        this.sumRepairMny = sumRepairMny;
    }
    public BigDecimal getSumOtherTaxMny() {
        return sumOtherTaxMny;
    }

    public void setSumOtherTaxMny(BigDecimal sumOtherTaxMny) {
        this.sumOtherTaxMny = sumOtherTaxMny;
    }
    public BigDecimal getSumOtherMny() {
        return sumOtherMny;
    }

    public void setSumOtherMny(BigDecimal sumOtherMny) {
        this.sumOtherMny = sumOtherMny;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

}
