package com.ejianc.business.storecloud.api;

import com.ejianc.business.storecloud.hystrix.WarehousHystrix;
import com.ejianc.business.storecloud.vo.WarehouseVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;


/**
 *
 *查询默认仓库
 */
@FeignClient(name= "cscec5b-storecloud-web", url="${common.env.feign-client-url}", path="cscec5b-storecloud-web", fallback = WarehousHystrix.class)
public interface IWarehouseApi {

	@GetMapping(value = "api/warehouse/queryStoreByProjectId")
	public CommonResponse<WarehouseVO> queryStoreByProjectId(@RequestBody Long projectId);

}
