package com.ejianc.business.storecloud.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.storecloud.bean.MaterialProjectEntity;
import com.ejianc.business.storecloud.service.IMaterialProjectService;
import com.ejianc.business.storecloud.vo.MaterialProjectVO;
/**
 * 项目领料设置-项目(材料表)
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialProject")
public class MaterialProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IMaterialApi materialApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMaterialProjectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<MaterialProjectVO>> saveOrUpdate(@RequestBody List<MaterialProjectVO> saveOrUpdateVO) {
        List<MaterialProjectVO> vo = service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialProjectVO> queryDetail(Long id) {
    	MaterialProjectEntity entity = service.selectById(id);
    	MaterialProjectVO vo = BeanMapper.map(entity, MaterialProjectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryDetail //同步云库房材料
     * @param
     */
    @RequestMapping(value = "/isSynchronization", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Integer> isSynchronization() {
        return CommonResponse.success("同步成功！", service.synchronization());
    }

    /**
     * @param id 物料分类父id
     * @description: 加载此物料分类的直接下级
     */
    @RequestMapping(value = "/lazyMaterialCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long parentId) {
        // 查询表格所有数据，把分类id转成集合，CommonResponse<IPage<MaterialOrgVO>>
        //materialApi.queryCategoryListByChildren(集合)
        List list = new ArrayList();
        LambdaQueryWrapper<MaterialProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialProjectEntity::getDr,0);
        List<MaterialProjectEntity> materialOrgEntities = service.list(queryWrapper);
        List<MaterialCategoryVO> materialCategoryVO = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(materialOrgEntities)){
            for (MaterialProjectEntity materialOrgEntity:materialOrgEntities){
                list.add(materialOrgEntity.getMaterialCategoryId());
            }
            CommonResponse<List<MaterialCategoryVO>> materialCategoryVOS = materialApi.queryCategoryListByChildren(list);
            List<MaterialCategoryVO> dateList = materialCategoryVOS.getData();
            if (parentId != null){
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() !=null && materialCategoryVO1.getParentId().equals(parentId)){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }else {
                materialCategoryVO.add(dateList.get(0));
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }
    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody  List<MaterialProjectVO> vos) {
        service.removeByIds(vos.stream().map(MaterialProjectVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialProjectVO>> queryList(@RequestBody QueryParam param) {
        List list = new ArrayList();// 用于查找分类树形
        List<MaterialProjectVO> list1 = new ArrayList();// 接收表格全部数据
        List<MaterialCategoryVO> materialCategoryVO = new ArrayList<>();// 接收选中树形及其子集
        if (param.getParams().size()!=0 && param.getParams().get("parentId").getValue() != null){
            LambdaQueryWrapper<MaterialProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(MaterialProjectEntity::getDr,0);
            List<MaterialProjectEntity> materialOrgEntities = service.list(queryWrapper);
            for (MaterialProjectEntity materialOrgEntity:materialOrgEntities){
                list.add(materialOrgEntity.getMaterialCategoryId());
                list1.add(BeanMapper.map(materialOrgEntity,MaterialProjectVO.class));// 表格全部数据列表
            }
            CommonResponse<List<MaterialCategoryVO>> materialCategoryVOS = materialApi.queryCategoryListByChildren(list);
            List<MaterialCategoryVO> dateList = materialCategoryVOS.getData();
            for (MaterialCategoryVO materialCategoryVO1:dateList){
                String[] materialCategories = materialCategoryVO1.getInnerCode().split("\\|");// 拆分所有树形InnerCode
                for (int i=0; i<materialCategories.length; i++){
                    if (param.getParams().get("parentId").getValue().equals(materialCategories[i])){// InnerCode中含有选中parentOrgId的即为选中树形及其子集
                        materialCategoryVO.add(materialCategoryVO1);// 已选择分类及其子集VO
                    }
                }
            }
        }

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        Long id = InvocationInfoProxy.getOrgId();
        System.out.println(id);
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<MaterialProjectEntity> page = service.queryPage(param,false);
        IPage<MaterialProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialProjectVO.class));
        if (CollectionUtils.isNotEmpty(list1)){
            for (MaterialProjectVO materialOrgVO:list1){
                for (MaterialCategoryVO materialCategoryVO1:materialCategoryVO){
                    if (materialCategoryVO1.getId().equals(materialOrgVO.getMaterialCategoryId())){// 循环表格全部数据getCategoryId与选中树形分类及子集getId进行判断
                        pageData.getRecords().add(materialOrgVO);
                    }
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialProjectVO>> refMaterialProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialProjectEntity> page = service.queryPage(param,false);
        IPage<MaterialProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialProjectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
