package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.storecloud.vo.MaterialOrgVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.storecloud.mapper.MaterialOrgMapper;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.service.IMaterialOrgService;

import java.util.ArrayList;
import java.util.List;

/**
 * 项目领料设置__项目
 *
 * @author generator
 *
 */
@Service("materialOrgService")
public class MaterialOrgServiceImpl extends BaseServiceImpl<MaterialOrgMapper, MaterialOrgEntity> implements IMaterialOrgService{

    @Autowired
    private IOrgApi iOrgApi;

    @Override
    public List<MaterialOrgVO> saveOrUpdate(List<MaterialOrgVO> saveOrUpdateVO) {
        List<MaterialOrgVO> vo = new ArrayList<>();
        for (MaterialOrgVO materialOrgVO : saveOrUpdateVO){
            if (materialOrgVO.getId()!=null){
                LambdaQueryWrapper<MaterialOrgEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(MaterialOrgEntity::getMaterialId,materialOrgVO.getId());
                queryWrapper.eq(MaterialOrgEntity::getOrgId,InvocationInfoProxy.getOrgId());
                queryWrapper.eq(MaterialOrgEntity::getDr,0);
                List<MaterialOrgEntity> materialOrgVOS = super.list(queryWrapper);
                if (CollectionUtils.isNotEmpty(materialOrgVOS)){
                    throw  new BusinessException("编号为"+materialOrgVO.getCode()+"的物资已被引用！");
                }
            }
            materialOrgVO.setMaterialId(materialOrgVO.getId());
            materialOrgVO.setMaterialCode(materialOrgVO.getCode());
            materialOrgVO.setMaterialName(materialOrgVO.getName());
            materialOrgVO.setUnit(materialOrgVO.getUnitName());
            materialOrgVO.setOrgId(InvocationInfoProxy.getOrgId());
            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(materialOrgVO.getOrgId());
            materialOrgVO.setOrgCode(orgVo.getData().getCode());
            materialOrgVO.setOrgName(orgVo.getData().getName());
            materialOrgVO.setParentOrgId(materialOrgVO.getCategoryId());
            MaterialOrgEntity entity = BeanMapper.map(materialOrgVO, MaterialOrgEntity.class);
            entity.setId(null);
            entity.setCreateUserName(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setTenantId(null);
            super.saveOrUpdate(entity, false);
            vo.add(BeanMapper.map(entity, MaterialOrgVO.class));
        }
        return vo;
    }
}
