/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.MaterialProjectEntity;
import com.ejianc.business.storecloud.service.IMaterialProjectService;
import com.ejianc.business.storecloud.vo.MaterialProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialProject"})
public class MaterialProjectController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialProjectService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<MaterialProjectVO>> saveOrUpdate(@RequestBody List<MaterialProjectVO> saveOrUpdateVO) {
        List<MaterialProjectVO> vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialProjectVO> queryDetail(Long id) {
        MaterialProjectEntity entity = (MaterialProjectEntity)((Object)this.service.selectById(id));
        MaterialProjectVO vo = (MaterialProjectVO)BeanMapper.map((Object)((Object)entity), MaterialProjectVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/isSynchronization"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Integer> isSynchronization() {
        return CommonResponse.success((String)"\u540c\u6b65\u6210\u529f\uff01", (Object)this.service.synchronization());
    }

    @RequestMapping(value={"/lazyMaterialCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long parentId) {
        ArrayList<Long> list = new ArrayList<Long>();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getDr, (Object)0);
        List materialOrgEntities = this.service.list((Wrapper)queryWrapper);
        ArrayList<Object> materialCategoryVO = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty((Collection)materialOrgEntities)) {
            for (MaterialProjectEntity materialOrgEntity : materialOrgEntities) {
                list.add(materialOrgEntity.getMaterialCategoryId());
            }
            CommonResponse materialCategoryVOS = this.materialApi.queryCategoryListByChildren(list);
            List dateList = (List)materialCategoryVOS.getData();
            if (parentId != null) {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() == null || !materialCategoryVO1.getParentId().equals(parentId)) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            } else {
                materialCategoryVO.add(dateList.get(0));
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialProjectVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialProjectVO>> queryList(@RequestBody QueryParam param) {
        ArrayList<Long> list = new ArrayList<Long>();
        ArrayList<Object> list1 = new ArrayList<Object>();
        ArrayList<MaterialCategoryVO> materialCategoryVO = new ArrayList<MaterialCategoryVO>();
        if (param.getParams().size() != 0 && ((Parameter)param.getParams().get("parentId")).getValue() != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            List materialOrgEntities = this.service.list((Wrapper)queryWrapper);
            for (MaterialProjectEntity materialOrgEntity : materialOrgEntities) {
                list.add(materialOrgEntity.getMaterialCategoryId());
                list1.add(BeanMapper.map((Object)((Object)materialOrgEntity), MaterialProjectVO.class));
            }
            CommonResponse materialCategoryVOS = this.materialApi.queryCategoryListByChildren(list);
            List dateList = (List)materialCategoryVOS.getData();
            for (MaterialCategoryVO materialCategoryVO2 : dateList) {
                String[] materialCategories = materialCategoryVO2.getInnerCode().split("\\|");
                for (int i = 0; i < materialCategories.length; ++i) {
                    if (!((Parameter)param.getParams().get("parentId")).getValue().equals(materialCategories[i])) continue;
                    materialCategoryVO.add(materialCategoryVO2);
                }
            }
        }
        List fuzzyFields = param.getFuzzyFields();
        Long id = InvocationInfoProxy.getOrgId();
        System.out.println(id);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialProjectVO.class));
        if (CollectionUtils.isNotEmpty(list1)) {
            for (MaterialProjectVO materialProjectVO : list1) {
                for (MaterialCategoryVO materialCategoryVO1 : materialCategoryVO) {
                    if (!materialCategoryVO1.getId().equals(materialProjectVO.getMaterialCategoryId())) continue;
                    pageData.getRecords().add(materialProjectVO);
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialProject-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialProjectData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialProjectVO>> refMaterialProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialProjectVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

