/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.utils;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Hashtable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QrCodeUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String QR_CODE_IMAGE_PATH = "D:/MyQRCode.png";
    private static final String QR_CODE_TEXT = "\u8fd9\u662f\u4e8c\u7ef4\u7801\u4e2d\u7684\u5185\u5bb9";
    private static int WIDTH = 300;
    private static int HEIGHT = 300;

    private static void generateQRCodeImage() throws WriterException, IOException {
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = qrCodeWriter.encode(QR_CODE_TEXT, BarcodeFormat.QR_CODE, WIDTH, HEIGHT, hints);
        bitMatrix.getEnclosingRectangle();
        Path path = FileSystems.getDefault().getPath(QR_CODE_IMAGE_PATH, new String[0]);
        MatrixToImageWriter.writeToPath((BitMatrix)bitMatrix, (String)"PNG", (Path)path);
    }

    public static void main(String[] args) throws Exception {
        QrCodeUtil.generateQRCodeImage();
    }
}

