/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"warehouse"})
public class WarehouseController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWarehouseService warehouseService;
    @Autowired
    private IWarehouseSurplusService surplusService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WarehouseVO> saveOrUpdate(@RequestBody WarehouseVO saveOrUpdateVO) {
        WarehouseVO vo = this.warehouseService.saveWarehouse(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WarehouseVO> queryDetail(Long id) {
        WarehouseEntity entity = (WarehouseEntity)((Object)this.warehouseService.selectById(id));
        WarehouseVO vo = (WarehouseVO)((Object)BeanMapper.map((Object)((Object)entity), WarehouseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WarehouseVO> vos) {
        List longs = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        for (Long key : longs) {
            WarehouseEntity warehouseEntity = (WarehouseEntity)((Object)this.warehouseService.selectById(key));
            if (BooleanUtils.isTrue((Boolean)warehouseEntity.getDefaultFlag())) {
                throw new BusinessException("\u4ed3\u5e93\u3010" + warehouseEntity.getWarehouseName() + "\u3011\u662f\u9879\u76ee\u9ed8\u8ba4\u4ed3\u5e93\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)key);
            if (!CollectionUtils.isNotEmpty((Collection)this.surplusService.list((Wrapper)queryWrapper))) continue;
            throw new BusinessException("\u4ed3\u5e93\u3010" + warehouseEntity.getWarehouseName() + "\u3011\u6709\u5e93\u5b58\u7269\u8d44\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        this.warehouseService.removeByIds(longs, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WarehouseVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("warehouseName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        IPage page = this.warehouseService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WarehouseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("warehouseName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        boolean mobile = param.getParams().containsKey("projectId");
        if (!mobile) {
            if (OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())) {
                param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
            }
        }
        List list = this.warehouseService.queryList(param);
        List resultMapList = null;
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            resultMapList = BeanMapper.mapList((Iterable)list, Map.class);
            resultMapList.forEach(vo -> {
                if (BooleanUtils.isTrue((Boolean)((Boolean)vo.get("state")))) {
                    vo.put("stateName", "\u542f\u7528");
                } else {
                    vo.put("stateName", "\u505c\u7528");
                }
                if (BooleanUtils.isTrue((Boolean)((Boolean)vo.get("defaultFlag")))) {
                    vo.put("defaultFlagName", "\u662f");
                } else {
                    vo.put("defaultFlagName", "\u5426");
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String createTime = sdf.format(vo.get("createTime"));
                vo.put("createTimeStr", createTime);
            });
        }
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", resultMapList);
        ExcelExport.getInstance().export("Warehouse-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refWarehouseData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WarehouseVO>> refWarehouseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject conjson;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter("eq", (Object)1));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conjson = JSONObject.parseObject((String)condition)).get((Object)"projectId")) {
            param.getParams().put("projectId", new Parameter("eq", conjson.get((Object)"projectId")));
        }
        IPage page = this.warehouseService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WarehouseVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/updateState"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> updateState(Long id, Boolean state) {
        WarehouseEntity entity = (WarehouseEntity)((Object)this.warehouseService.selectById(id));
        entity.setState(state);
        this.warehouseService.saveOrUpdate((Object)entity);
        return CommonResponse.success((String)"\u66f4\u65b0\u542f\u7528\u505c\u7528\u6210\u529f!");
    }

    @RequestMapping(value={"/createQRCode"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WarehouseVO> createQRCode(Long id) {
        WarehouseVO vo = this.warehouseService.createQRCode(id);
        return CommonResponse.success((String)"\u751f\u6210\u4e8c\u7ef4\u7801\u6210\u529f\uff01", (Object)((Object)vo));
    }
}

