/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.ApplyEntity;
import com.ejianc.business.storecloud.bean.PersionProjectEntity;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.mapper.ApplyMapper;
import com.ejianc.business.storecloud.service.IApplyService;
import com.ejianc.business.storecloud.service.IPersionProjectService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.utils.WeChatUtil;
import com.ejianc.business.storecloud.vo.ApplyVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="applyService")
public class ApplyServiceImpl
extends BaseServiceImpl<ApplyMapper, ApplyEntity>
implements IApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "FBLL_LLCK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWarehouseService warehouseService;
    @Autowired
    private IPersionProjectService persionProjectService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private IAttachmentApi attachmentApi;

    @Override
    public ApplyVO saveApply(ApplyVO saveOrUpdateVO) {
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setIsFlag(0);
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        CommonResponse orgVO = this.iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        entity.setOrgName(((OrgVO)orgVO.getData()).getName());
        this.saveOrUpdate((Object)entity, false);
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)entity), ApplyVO.class));
    }

    @Override
    public ApplyVO addForScan(Long storeId, String openId) {
        ApplyVO applyVO = new ApplyVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getId, (Object)storeId);
        WarehouseEntity warehouseEntity = (WarehouseEntity)((Object)this.warehouseService.getOne((Wrapper)queryWrapper, false));
        applyVO.setOrgId(warehouseEntity.getOrgId());
        applyVO.setOrgName(warehouseEntity.getOrgName());
        applyVO.setProjectId(warehouseEntity.getProjectId());
        applyVO.setProjectName(warehouseEntity.getProjectName());
        applyVO.setStoreId(warehouseEntity.getId());
        applyVO.setStoreName(warehouseEntity.getWarehouseName());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PersionProjectEntity::getOpenId, (Object)openId);
        PersionProjectEntity persionProjectEntity = (PersionProjectEntity)((Object)this.persionProjectService.getOne((Wrapper)wrapper, false));
        applyVO.setSupplyId(persionProjectEntity.getSupplyId());
        applyVO.setSupplyName(persionProjectEntity.getSupplyName());
        applyVO.setContractId(persionProjectEntity.getContractId());
        applyVO.setContractCode(persionProjectEntity.getContractCode());
        applyVO.setContractName(persionProjectEntity.getContractName());
        applyVO.setPickingId(persionProjectEntity.getId());
        applyVO.setPickingName(persionProjectEntity.getName());
        return applyVO;
    }

    @Override
    public ApplyVO createQRCode(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        String accessroken = "";
        this.logger.debug("\u83b7\u53d6accessroken:=====" + accessroken);
        if (null == this.redisTemplate.opsForValue().get((Object)"sc_access_token")) {
            accessroken = this.weChatUtil.getAccesstoken();
            if (!StringUtils.isEmpty((CharSequence)accessroken)) {
                this.redisTemplate.opsForValue().set((Object)"sc_access_token", (Object)accessroken, 90L, TimeUnit.MINUTES);
            }
            this.logger.debug("\u83b7\u53d6accessroken:" + accessroken);
        } else {
            accessroken = this.redisTemplate.opsForValue().get((Object)"sc_access_token").toString();
        }
        String path = "applyCard?storeId=" + id;
        String multipartFile = this.weChatUtil.createLongQRCodeStr(path, String.valueOf(id), accessroken);
        applyEntity.setQrcode(this.dealImg(multipartFile, applyEntity));
        this.saveOrUpdate((Object)applyEntity);
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class));
    }

    @Override
    public ApplyVO queryDetail(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        if (0 == applyEntity.getIsFlag() && 1 == applyEntity.getCoseFlag()) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date checkTime = sdf.parse(applyEntity.getApplyForDate());
                Date d = new Date();
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(checkTime);
                ((Calendar)calendar).add(12, 120);
                if (1 == d.compareTo(calendar.getTime())) {
                    applyEntity.setIsFlag(2);
                    this.updateById((Object)applyEntity);
                }
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage());
            }
        }
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class));
    }

    private String dealImg(String file, ApplyEntity applyEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202208000007");
        attachmentVO.setSourceId(String.valueOf(applyEntity.getId()));
        attachmentVO.setSourceType("EJCBT202208000007");
        attachmentVO.setFileList(Arrays.asList(file));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

