/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.storecloud.bean.ConfigProjectEntity;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.bean.MaterialProjectEntity;
import com.ejianc.business.storecloud.mapper.MaterialProjectMapper;
import com.ejianc.business.storecloud.service.IConfigProjectService;
import com.ejianc.business.storecloud.service.IMaterialOrgService;
import com.ejianc.business.storecloud.service.IMaterialProjectService;
import com.ejianc.business.storecloud.vo.MaterialProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialProjectService")
public class MaterialProjectServiceImpl
extends BaseServiceImpl<MaterialProjectMapper, MaterialProjectEntity>
implements IMaterialProjectService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConfigProjectService configProjectService;
    @Autowired
    private IMaterialOrgService materialOrgService;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public List<MaterialProjectVO> saveOrUpdate(List<MaterialProjectVO> saveOrUpdateVO) {
        ArrayList<MaterialProjectVO> vo = new ArrayList<MaterialProjectVO>();
        for (MaterialProjectVO materialProjectVO : saveOrUpdateVO) {
            if (materialProjectVO.getId() != null) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(MaterialProjectEntity::getMaterialId, (Object)materialProjectVO.getId());
                queryWrapper.eq(MaterialProjectEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
                queryWrapper.eq(BaseEntity::getDr, (Object)0);
                List materialProjectEntityList = super.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)materialProjectEntityList)) {
                    throw new BusinessException("\u7f16\u53f7\u4e3a" + materialProjectVO.getCode() + "\u7684" + materialProjectVO.getName() + "\u5df2\u88ab\u5f15\u7528\uff01");
                }
            }
            materialProjectVO.setMaterialId(materialProjectVO.getId());
            materialProjectVO.setMaterialCode(materialProjectVO.getCode());
            materialProjectVO.setMaterialName(materialProjectVO.getName());
            materialProjectVO.setMaterialUnitName(materialProjectVO.getUnitName());
            materialProjectVO.setMaterialSpec(materialProjectVO.getSpec());
            materialProjectVO.setMaterialCategoryId(materialProjectVO.getCategoryId());
            materialProjectVO.setMaterialCategoryName(materialProjectVO.getCategoryName());
            materialProjectVO.setMaterialCategoryCode(materialProjectVO.getCategoryCode());
            CommonResponse materialCategoryVO = this.materialApi.queryCategoryById(materialProjectVO.getCategoryId());
            materialProjectVO.setMaterialCategoryInnerCode(((MaterialCategoryVO)materialCategoryVO.getData()).getInnerCode());
            materialProjectVO.setOrgId(InvocationInfoProxy.getOrgId());
            CommonResponse orgVo = this.iOrgApi.detailById(materialProjectVO.getOrgId());
            materialProjectVO.setOrgCode(((OrgVO)orgVo.getData()).getCode());
            materialProjectVO.setOrgName(((OrgVO)orgVo.getData()).getName());
            MaterialProjectEntity entity = (MaterialProjectEntity)((Object)BeanMapper.map((Object)materialProjectVO, MaterialProjectEntity.class));
            entity.setId(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setTenantId(null);
            super.saveOrUpdate((Object)entity, false);
            vo.add((MaterialProjectVO)BeanMapper.map((Object)((Object)entity), MaterialProjectVO.class));
        }
        return vo;
    }

    @Override
    public int synchronization() {
        ConfigProjectEntity configProjectEntity = this.configProjectService.queryConfig(InvocationInfoProxy.getOrgId());
        String innerCode = configProjectEntity.getParentInnerCode();
        String[] strs = innerCode.split("\\|");
        ArrayList<Long> childIds = new ArrayList<Long>();
        for (String id : strs) {
            if (Long.parseLong(id) == InvocationInfoProxy.getOrgId()) continue;
            childIds.add(Long.parseLong(id));
        }
        Collections.reverse(childIds);
        List materialOrgEntityList = new ArrayList();
        for (Long orgId : childIds) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(MaterialOrgEntity::getOrgId, (Object)orgId);
            materialOrgEntityList = this.materialOrgService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty(materialOrgEntityList)) continue;
            break;
        }
        if (CollectionUtils.isEmpty(materialOrgEntityList)) {
            throw new BusinessException("\u76f4\u5c5e\u4e0a\u7ea7\u672a\u8bbe\u7f6e\u4e91\u5e93\u5b58\u6750\u6599\uff0c\u540c\u6b65\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty(materialOrgEntityList)) {
            for (MaterialOrgEntity materialOrgEntity : materialOrgEntityList) {
                MaterialProjectEntity materialProjectEntity = new MaterialProjectEntity();
                materialProjectEntity.setMaterialId(materialOrgEntity.getMaterialId());
                materialProjectEntity.setMaterialCode(materialOrgEntity.getMaterialCode());
                materialProjectEntity.setMaterialName(materialOrgEntity.getMaterialName());
                materialProjectEntity.setMaterialSpec(materialOrgEntity.getSpec());
                materialProjectEntity.setMaterialUnitName(materialOrgEntity.getUnit());
                materialProjectEntity.setMaterialCategoryId(materialOrgEntity.getCategoryId());
                materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
                materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
                materialProjectEntity.setOrgId(InvocationInfoProxy.getOrgId());
                CommonResponse parentOrgList = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
                materialProjectEntity.setOrgCode(((OrgVO)((List)parentOrgList.getData()).get(0)).getCode());
                materialProjectEntity.setParentId(((OrgVO)((List)parentOrgList.getData()).get(0)).getParentId());
                materialProjectEntity.setOrgName(((OrgVO)((List)parentOrgList.getData()).get(0)).getName());
                if (materialOrgEntity.getMaterialId() != null) {
                    LambdaQueryWrapper queryWrappers = new LambdaQueryWrapper();
                    queryWrappers.eq(MaterialProjectEntity::getMaterialId, (Object)materialOrgEntity.getMaterialId());
                    queryWrappers.eq(MaterialProjectEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
                    queryWrappers.eq(BaseEntity::getDr, (Object)0);
                    List materialProjectEntityList = super.list((Wrapper)queryWrappers);
                    if (CollectionUtils.isNotEmpty((Collection)materialProjectEntityList)) continue;
                }
                this.saveOrUpdate((Object)materialProjectEntity);
            }
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(ConfigProjectEntity::getInitializeEnabled, (Object)1);
            updateWrapper.set(ConfigProjectEntity::getEnabled, (Object)1);
            updateWrapper.eq(ConfigProjectEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
            boolean flag = this.configProjectService.update((Wrapper)updateWrapper);
            if (!flag) {
                throw new BusinessException("\u8bbe\u7f6e\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
            }
        } else {
            return 1;
        }
        return 0;
    }
}

