package com.ejianc.business.storecloud.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.service.IMaterialOrgService;
import com.ejianc.business.storecloud.vo.MaterialOrgVO;
/**
 * 项目领料设置__项目
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("materialOrg")
public class MaterialOrgController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired(required = false)
    private RestHighLevelClient client;
    private final static String INDEX_NAME_MATERIAL_CATEGORY = "ejc_material_report_material_category";
    private final static Integer QUERY_TIMEOUT = 60;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IMaterialOrgService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<MaterialOrgVO>> saveOrUpdate(@RequestBody List<MaterialOrgVO> saveOrUpdateVO) {
    	List<MaterialOrgVO> vo = service.saveOrUpdate(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialOrgVO> queryDetail(Long id) {
    	MaterialOrgEntity entity = service.selectById(id);
    	MaterialOrgVO vo = BeanMapper.map(entity, MaterialOrgVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialOrgVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (MaterialOrgVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(MaterialOrgVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialOrgVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        if (param.getParams().size()!=0 && param.getParams().get("categoryId").getValue() != null){
            param.getParams().put("categoryInnerCode", new Parameter(QueryParam.LIKE, param.getParams().get("categoryId").getValue()));
            param.getParams().remove("categoryId");
        }
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.EQ,InvocationInfoProxy.getOrgId()));//只查询当前组织，不查询本下
        IPage<MaterialOrgEntity> page = service.queryPage(param,false);
        IPage<MaterialOrgVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialOrgVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MaterialOrgEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialOrg-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialOrgData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialOrgVO>> refMaterialOrgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MaterialOrgEntity> page = service.queryPage(param,false);
        IPage<MaterialOrgVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialOrgVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @param id 物料分类父id
     * @description: 加载此物料分类的直接下级
     * @return: com.ejianc.framework.core.response.CommonResponse<java.util.List < com.ejianc.foundation.share.vo.MaterialCategoryVO>>
     * @author songlx
     * @date: 2021-04-14
     */
    @RequestMapping(value = "/lazyMaterialCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long parentId) {
        List<MaterialCategoryVO> materialCategoryVO = new ArrayList<>();
        List list = new ArrayList();
        LambdaQueryWrapper<MaterialOrgEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(MaterialOrgEntity::getDr,0);
        queryWrapper.eq(MaterialOrgEntity::getOrgId,InvocationInfoProxy.getOrgId());//只查询当前组织
        queryWrapper.like(parentId != null,MaterialOrgEntity::getCategoryInnerCode,parentId);
        List<MaterialOrgEntity> materialOrgEntities = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(materialOrgEntities)){
            for (MaterialOrgEntity materialOrgEntity:materialOrgEntities){
                list.add(materialOrgEntity.getCategoryId());
            }
            CommonResponse<List<MaterialCategoryVO>> materialCategoryVOS = materialApi.queryCategoryListByChildren(list);
            List<MaterialCategoryVO> dateList = materialCategoryVOS.getData();
            if (parentId != null){ // 选择树形查找子集
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() !=null && materialCategoryVO1.getParentId().equals(parentId)){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }else { // 刷新页面查询全部树形
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() ==null ){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }
}
