package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.ApplyEntity;
import com.ejianc.business.storecloud.bean.PersionProjectEntity;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.mapper.ApplyMapper;
import com.ejianc.business.storecloud.service.IApplyService;
import com.ejianc.business.storecloud.service.IPersionProjectService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.utils.WeChatUtil;
import com.ejianc.business.storecloud.vo.ApplyVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.TimeUnit;

/**
 * 分包人员领料出库
 *
 * @author generator
 *
 */
@Service("applyService")
public class ApplyServiceImpl extends BaseServiceImpl<ApplyMapper, ApplyEntity> implements IApplyService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String BILL_CODE = "FBLL_LLCK";//此处需要根据实际修改

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWarehouseService warehouseService;

    @Autowired
    private IPersionProjectService persionProjectService;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Override
    public ApplyVO saveApply(ApplyVO saveOrUpdateVO) {
        ApplyEntity entity = BeanMapper.map(saveOrUpdateVO, ApplyEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
     /*   //保存校验处理但不占用数量
        List<ApplyDetailEntity> applyDetailEntityList = entity.getApplyDetailEntityList();

        if(CollectionUtils.isNotEmpty(applyDetailEntityList)){
            for (ApplyDetailEntity applyDetailEntity : applyDetailEntityList){
                LambdaQueryWrapper<WarehouseSurplusEntity> queryWrapper = new LambdaQueryWrapper<WarehouseSurplusEntity>();
                queryWrapper.eq(WarehouseSurplusEntity::getMaterialId,applyDetailEntity.getMaterialId());
                queryWrapper.eq(WarehouseSurplusEntity::getDr,0);
                WarehouseSurplusEntity warehouseSurplusEntity = surplusService.getOne(queryWrapper);//一个物质只有一条数据，如果有多条，数据错误
                BigDecimal surplusNum = warehouseSurplusEntity.getSurplusNum();//库存余量
                if(applyDetailEntity.getApplyNumber().compareTo(surplusNum) > 0){
                    throw new BusinessException("您申请的物质【" + applyDetailEntity.getMaterialName() + "】库存不足，库存余量为【" +surplusNum + "】！");
                }
            }
        }*/
        entity.setIsFlag(0);//默认未出库
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        CommonResponse<OrgVO> orgVO = iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        entity.setOrgName(orgVO.getData().getName());
        saveOrUpdate(entity, false);
        return BeanMapper.map(entity, ApplyVO.class);
    }

    @Override
    public ApplyVO addForScan(Long storeId, String openId) {
        ApplyVO applyVO = new ApplyVO();
        LambdaQueryWrapper<WarehouseEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WarehouseEntity::getId, storeId);
        WarehouseEntity warehouseEntity = warehouseService.getOne(queryWrapper, false);
        applyVO.setOrgId(warehouseEntity.getOrgId());
        applyVO.setOrgName(warehouseEntity.getOrgName());
        applyVO.setProjectId(warehouseEntity.getProjectId());
        applyVO.setProjectName(warehouseEntity.getProjectName());
        applyVO.setStoreId(warehouseEntity.getId());
        applyVO.setStoreName(warehouseEntity.getWarehouseName());
        LambdaQueryWrapper<PersionProjectEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PersionProjectEntity::getOpenId, openId);
        PersionProjectEntity persionProjectEntity = persionProjectService.getOne(wrapper, false);
        applyVO.setSupplyId(persionProjectEntity.getSupplyId());
        applyVO.setSupplyName(persionProjectEntity.getSupplyName());
        applyVO.setContractId(persionProjectEntity.getContractId());
        applyVO.setContractCode(persionProjectEntity.getContractCode());
        applyVO.setContractName(persionProjectEntity.getContractName());
        applyVO.setPickingId(persionProjectEntity.getId());
        applyVO.setPickingName(persionProjectEntity.getName());
        return applyVO;
    }

    @Override
    public ApplyVO createQRCode(Long id) {
        ApplyEntity applyEntity = selectById(id);
        String accessroken = "";
        logger.debug("获取accessroken:=====" + accessroken);
        if(null == redisTemplate.opsForValue().get("sc_access_token")){
            accessroken = weChatUtil.getAccesstoken();
            if(!StringUtils.isEmpty(accessroken)){
                redisTemplate.opsForValue().set("sc_access_token", accessroken, 90, TimeUnit.MINUTES);
            }
            logger.debug("获取accessroken:"+accessroken);
        }else{
            accessroken = redisTemplate.opsForValue().get("sc_access_token").toString();
        }
        String path = "applyCard?storeId=" + id;
        String multipartFile =  weChatUtil.createLongQRCodeStr(path, String.valueOf(id), accessroken);
        String baseAddr = null;
        if (baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        }else if(baseHost.contains("9082")){
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        }else if(baseHost.contains("9080")){
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        applyEntity.setQrcode(baseAddr + dealImg(multipartFile, applyEntity));
        saveOrUpdate(applyEntity);
        return BeanMapper.map(applyEntity, ApplyVO.class);
    }

    @Override
    public ApplyVO queryDetail(Long id) {
        ApplyEntity applyEntity = selectById(id);
        if(0 == applyEntity.getIsFlag() && 1 == applyEntity.getCoseFlag()){
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date checkTime = sdf.parse(applyEntity.getApplyForDate());
                Date d = new Date();
                Calendar calendar = new GregorianCalendar();
                calendar.setTime(checkTime);
                calendar.add(calendar.MINUTE, 120);
                if(1 == d.compareTo(calendar.getTime())){
                    applyEntity.setIsFlag(2);
                    updateById(applyEntity);
                }
            } catch (ParseException e) {
                logger.error(e.getMessage());
            }
        }
        return BeanMapper.map(applyEntity, ApplyVO.class);
    }

    /**
     * 上传图片
     * @return
     */
    private String dealImg(String file, ApplyEntity applyEntity){
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202208000007");
        attachmentVO.setSourceId(String.valueOf(applyEntity.getId()));
        attachmentVO.setSourceType("EJCBT202208000007");
        attachmentVO.setFileList(Arrays.asList(file));
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentVO);
        logger.info("图片列表数据前:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return listCommonResponse.getData().get(0).getFilePath();
        }
        return null;
    }
}
