package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.storecloud.bean.OutDetailEntity;
import com.ejianc.business.storecloud.bean.OutEntity;
import com.ejianc.business.storecloud.service.IOutService;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.vo.OutVO;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Service("out")
public class OutBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IWarehouseFlowService warehouseFlowService;

	@Autowired
	private IOutService outService;


	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("======================================提交前回调====================================== state:"+state);
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("======================================提交完回调====================================== state:"+state);
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		logger.info("======================================有审批流的撤回前回调====================================== state:"+state);
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("有审批流的撤回后回调,------------------------------------------------------->: {}", state);
		OutEntity outEntity = outService.selectById(billId);
		List<Long> ids = new ArrayList<>();
		for(OutDetailEntity outDetailEntity : outEntity.getOutDetailEntityList()){
			ids.add(outDetailEntity.getId());
		}
		for( Long id: ids){
			logger.info("弃审id,------------------------------------------------------->: {}", id);
		}
		WarehouseManageVO manageVO = new WarehouseManageVO();
		manageVO.setProjectId(outEntity.getProjectId());
		manageVO.setStoreId(outEntity.getStoreId());
		manageVO.setInOutFlag(2);
		manageVO.setDelDetailIdList(ids);
		warehouseFlowService.rollBack(manageVO);
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//提交前占用数量
		logger.info("======================================终审审核前回调====================================== state:"+state);
		if(state == 0 || state == 2) {
			List<WarehouseFlowVO> warehouseFlowVOList= new ArrayList<>();
			OutEntity outEntity = outService.selectById(billId);
			List<OutDetailEntity> outDetailEntityList = outEntity.getOutDetailEntityList();
			for(OutDetailEntity outDetailEntity : outDetailEntityList){
				WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
				warehouseFlowVO.setBillCode(outEntity.getBillCode());
				warehouseFlowVO.setBillDate(outEntity.getCreateTime());
				warehouseFlowVO.setProjectId(outEntity.getProjectId());
				warehouseFlowVO.setProjectName(outEntity.getProjectName());
				warehouseFlowVO.setParentOrgId(outEntity.getOrgId());
				warehouseFlowVO.setParentOrgCode(outEntity.getOrgCode());
				warehouseFlowVO.setParentOrgName(outEntity.getOrgName());
				warehouseFlowVO.setStoreId(outEntity.getStoreId());
				warehouseFlowVO.setStoreName(outEntity.getStoreName());
				warehouseFlowVO.setEmployeeName(outEntity.getCreateUserCode());
				warehouseFlowVO.setInOutType(outEntity.getCoseFlag());
				if(outEntity.getCoseFlag() == 3){
					warehouseFlowVO.setInOutTypeName("领料出库");
				}else{
					warehouseFlowVO.setInOutTypeName("直接出库");
				}
				warehouseFlowVO.setInOutFlag(2);//出库
				warehouseFlowVO.setMaterialType(outDetailEntity.getMaterialType());//不能为空--前端未赋值
				warehouseFlowVO.setMaterialTypeName(outDetailEntity.getMaterialTypeName());
				warehouseFlowVO.setMaterialCategoryId(outDetailEntity.getMaterialCategoryId());
				warehouseFlowVO.setMaterialCategoryName(outDetailEntity.getMaterialCategoryName());
				warehouseFlowVO.setMaterialCategoryCode(outDetailEntity.getMaterialCategoryCode());//不能为空--前端未赋值
				warehouseFlowVO.setMaterialId(outDetailEntity.getMaterialId());
				warehouseFlowVO.setMaterialName(outDetailEntity.getMaterialName());
				warehouseFlowVO.setMaterialCode(outDetailEntity.getMaterialCode());
				warehouseFlowVO.setMaterialSpec(outDetailEntity.getMaterialSpec());
				warehouseFlowVO.setMaterialUnitName(outDetailEntity.getMaterialUnitName());
				warehouseFlowVO.setPrice(outDetailEntity.getSurplusPrice());//不能为空--前端未赋值
				warehouseFlowVO.setTaxPrice(outDetailEntity.getSurplusTaxPrice());
				//todo数量对应出库数量
				warehouseFlowVO.setNum(outDetailEntity.getDeliveryNumber());//不能为空--前端未赋值
				warehouseFlowVO.setMny(ComputeUtil.safeMultiply(outDetailEntity.getDeliveryNumber(), outDetailEntity.getSurplusPrice()));
				warehouseFlowVO.setTaxMny(ComputeUtil.safeMultiply(outDetailEntity.getDeliveryNumber(), outDetailEntity.getSurplusTaxPrice()));//需要验证
				warehouseFlowVO.setSourceBillTypeCode("EJCBT202208000010");
				warehouseFlowVO.setSourceBillTypeName("内部人员领料出库");
				warehouseFlowVO.setSourceId(outEntity.getId());
				warehouseFlowVO.setSourceDetailId(outDetailEntity.getId());
				warehouseFlowVO.setSourceBillCode(outEntity.getBillCode());
				warehouseFlowVO.setSourceBillDate(outEntity.getCreateTime());
				warehouseFlowVOList.add(warehouseFlowVO);
			}
			for(WarehouseFlowVO warehouseFlowVO: warehouseFlowVOList){
				logger.info("出库流水,sss---------->: {}", JSONObject.toJSONString(warehouseFlowVO));
			}
			WarehouseManageVO manageVO = new WarehouseManageVO();
			manageVO.setProjectId(outEntity.getProjectId());
			manageVO.setStoreId(outEntity.getStoreId());
			manageVO.setInOutFlag(2);
			manageVO.setFlowVOList(warehouseFlowVOList);
			CommonResponse<String> flag = warehouseFlowService.push(manageVO);
			logger.info("flag----------------------------------", JSONObject.toJSONString(flag));
			if( flag!= null && !flag.getMsg().equals("插入流水成功") ){
				throw new BusinessException(flag.getMsg());
			}
			return flag;
		}

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
