package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseFlowEntity;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.storecloud.mapper.WarehouseInoutMapper;
import com.ejianc.business.storecloud.bean.WarehouseInoutEntity;
import com.ejianc.business.storecloud.service.IWarehouseInoutService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 仓库出库关联表
 *
 * @author generator
 *
 */
@Service("warehouseInoutService")
public class WarehouseInoutServiceImpl extends BaseServiceImpl<WarehouseInoutMapper, WarehouseInoutEntity> implements IWarehouseInoutService {

    @Autowired
    private IWarehouseFlowService warehouseFlowService;

    @Override
    public CommonResponse<String> updateInout(List<WarehouseFlowEntity> flowEntityList, boolean isSave) {
        List<WarehouseInoutEntity> inoutList = new ArrayList<>();
        if(isSave){
            for (WarehouseFlowEntity outFlowEntity : flowEntityList) {
                LambdaQueryWrapper<WarehouseFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(WarehouseFlowEntity::getProjectId, outFlowEntity.getProjectId());
                queryWrapper.eq(WarehouseFlowEntity::getStoreId, outFlowEntity.getStoreId());
                queryWrapper.eq(WarehouseFlowEntity::getMaterialId, outFlowEntity.getMaterialId());
                queryWrapper.eq(WarehouseFlowEntity::getInOutFlag, 1);
                queryWrapper.orderByAsc(WarehouseFlowEntity::getCreateTime);
                List<WarehouseFlowEntity> inFlowEntities = warehouseFlowService.list(queryWrapper);
                if(CollectionUtils.isNotEmpty(inFlowEntities)){
                    for(WarehouseFlowEntity inFlowEntity : inFlowEntities){
                        QueryWrapper<WarehouseInoutEntity> wrapper = new QueryWrapper<>();
                        wrapper.select("sum(num) as num");
                        wrapper.eq("in_flow_id", inFlowEntity.getId());
                        WarehouseInoutEntity sumEntity = getOne(wrapper);
                        BigDecimal sunNum = sumEntity == null ? null : sumEntity.getNum();
                        if(ComputeUtil.isGreaterThan(inFlowEntity.getNum(), sunNum)){
                            BigDecimal sub = ComputeUtil.safeSub(inFlowEntity.getNum(), sunNum);
                            if(ComputeUtil.isLessOrEqual(outFlowEntity.getNum(), sub)){
                                inoutList.add(covertEntity(outFlowEntity, inFlowEntity));
                                break;
                            }else{
                                WarehouseInoutEntity inoutEntity = covertEntity(outFlowEntity, inFlowEntity);
                                inoutEntity.setNum(sub);
                                inoutEntity.setMny(ComputeUtil.safeMultiply(inoutEntity.getPrice(), sub));
                                inoutEntity.setTaxMny(ComputeUtil.safeMultiply(inoutEntity.getTaxPrice(), sub));
                                inoutList.add(inoutEntity);
                                outFlowEntity.setNum(ComputeUtil.safeSub(outFlowEntity.getNum(), sub));
                                outFlowEntity.setMny(ComputeUtil.safeMultiply(outFlowEntity.getPrice(), sub));
                                outFlowEntity.setTaxMny(ComputeUtil.safeMultiply(outFlowEntity.getTaxPrice(), sub));
                            }
                        }
                    }
                }
            }
            saveOrUpdateBatch(inoutList);
        }else{
            List<Long> srcDetailidList =  flowEntityList.stream().map(WarehouseFlowEntity::getSourceDetailId).collect(Collectors.toList());
            LambdaQueryWrapper<WarehouseInoutEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(WarehouseInoutEntity::getOutBillDetailId, srcDetailidList);
            remove(queryWrapper);
        }
        return CommonResponse.success("更新仓库出库关联表成功！");
    }

    private WarehouseInoutEntity covertEntity(WarehouseFlowEntity outFlowEntity, WarehouseFlowEntity inFlowEntity){
        WarehouseInoutEntity inoutEntity = BeanMapper.map(outFlowEntity, WarehouseInoutEntity.class);
        inoutEntity.setInFlowId(inFlowEntity.getId());
        inoutEntity.setOutFlowId(outFlowEntity.getId());
        inoutEntity.setProjectId(inFlowEntity.getProjectId());
        inoutEntity.setProjectName(inFlowEntity.getProjectName());
        inoutEntity.setStoreId(inFlowEntity.getStoreId());
        inoutEntity.setStoreName(inFlowEntity.getProjectName());
        inoutEntity.setOutDate(outFlowEntity.getBillDate());
        inoutEntity.setInOutType(outFlowEntity.getInOutType());
        inoutEntity.setInOutTypeName(outFlowEntity.getInOutTypeName());
        inoutEntity.setInBillId(inFlowEntity.getSourceId());
        inoutEntity.setInBillDetailId(inFlowEntity.getSourceDetailId());
        inoutEntity.setInBillCode(inFlowEntity.getBillCode());
        inoutEntity.setOutBillId(outFlowEntity.getSourceId());
        inoutEntity.setOutBillDetailId(outFlowEntity.getSourceDetailId());
        inoutEntity.setOutDate(outFlowEntity.getBillDate());
        return  inoutEntity;
    }
}
