package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.storecloud.utils.WeChatUtil;
import com.ejianc.business.storecloud.vo.WarehouseVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.storecloud.mapper.WarehouseMapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.service.IWarehouseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

/**
 * 仓库
 *
 * @author generator
 *
 */
@Service("warehouseService")
public class WarehouseServiceImpl extends BaseServiceImpl<WarehouseMapper, WarehouseEntity> implements IWarehouseService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    @Value("${common.env.base-host}")
    private String baseHost;

    private static final String BILL_CODE = "WAREHOUSE_CODE";

    @Override
    public WarehouseVO saveWarehouse(WarehouseVO saveOrUpdateVO) {
        WarehouseEntity entity = BeanMapper.map(saveOrUpdateVO, WarehouseEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }

            LambdaQueryWrapper<WarehouseEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(WarehouseEntity::getProjectId, entity.getProjectId());
            queryWrapper.eq(WarehouseEntity::getWarehouseName, entity.getWarehouseName());
            if (CollectionUtils.isNotEmpty(list(queryWrapper))) {
                throw new BusinessException("仓库名在该项目下已存在！");
            }
        }
        updateDefaultFlag(entity.getProjectId(), entity.getId(), entity.getDefaultFlag());
        saveOrUpdate(entity, false);

        return BeanMapper.map(entity, WarehouseVO.class);
    }

    @Override
    public WarehouseVO createQRCode(Long id) {
        WarehouseEntity warehouseEntity = selectById(id);
        String accessroken = "";
        if(null == redisTemplate.opsForValue().get("sc_access_token")){
            accessroken = weChatUtil.getAccesstoken();
            if(!StringUtils.isEmpty(accessroken)){
                redisTemplate.opsForValue().set("sc_access_token", accessroken, 90, TimeUnit.MINUTES);
            }
            logger.info("获取accessroken:"+accessroken);
        }else{
            accessroken = redisTemplate.opsForValue().get("sc_access_token").toString();
            logger.info("获取accessroken:=====" + accessroken);
        }
        String path = "applyCard?storeId=" + id;
        String multipartFile =  weChatUtil.createLongQRCodeStr(path, String.valueOf(id), accessroken);
        String baseAddr = null;
        if (baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        }else if(baseHost.contains("9082")){
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        }else if(baseHost.contains("9080")){
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        warehouseEntity.setQrcode(baseAddr + dealImg(multipartFile, warehouseEntity));
        saveOrUpdate(warehouseEntity);
        return BeanMapper.map(warehouseEntity, WarehouseVO.class);
    }

    private void updateDefaultFlag(Long projectId, Long id, Boolean defaultFlag){
        if(BooleanUtils.isTrue(defaultFlag)){
            LambdaUpdateWrapper<WarehouseEntity> updateWrapper = new LambdaUpdateWrapper<>();
            updateWrapper.eq(WarehouseEntity::getProjectId, projectId);
            updateWrapper.ne(null != id, WarehouseEntity::getId, id);
            updateWrapper.set(WarehouseEntity::getDefaultFlag, false);
            update(updateWrapper);
        }
    }

    /**
     * 上传图片
     * @return
     */
    private String dealImg(String file, WarehouseEntity warehouseEntity){
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202208000014");
        attachmentVO.setSourceId(String.valueOf(warehouseEntity.getId()));
        attachmentVO.setSourceType("EJCBT202208000014");
        attachmentVO.setFileList(Arrays.asList(file));
        attachmentVO.setProjectcode(warehouseEntity.getProjectCode());
        logger.info(JSON.toJSONString(attachmentVO));
        CommonResponse<List<AttachmentVO>> listCommonResponse = attachmentApi.uploadForBase64(attachmentVO);
        logger.info("图片列表数据前:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return listCommonResponse.getData().get(0).getFilePath();
        }
        return null;
    }
}
