/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.OutDetailEntity;
import com.ejianc.business.storecloud.bean.OutEntity;
import com.ejianc.business.storecloud.bean.PickingEntity;
import com.ejianc.business.storecloud.service.IOutService;
import com.ejianc.business.storecloud.service.IPickingService;
import com.ejianc.business.storecloud.vo.PickingVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"picking"})
public class PickingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IPickingService service;
    @Autowired
    private IOutService outService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PickingVO> saveOrUpdate(@RequestBody PickingVO saveOrUpdateVO) {
        PickingEntity entity = (PickingEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), PickingEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PickingVO vo = (PickingVO)((Object)BeanMapper.map((Object)((Object)entity), PickingVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PickingVO> queryDetail(Long id) {
        PickingEntity entity = (PickingEntity)((Object)this.service.selectById(id));
        PickingVO vo = (PickingVO)((Object)BeanMapper.map((Object)((Object)entity), PickingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PickingVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (PickingVO pickingVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PickingVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        ArrayList<PickingVO> pickingVOList = new ArrayList<PickingVO>();
        List outEntityList = this.outService.queryList(param);
        for (OutEntity outEntity : outEntityList) {
            OutEntity outEntity1 = (OutEntity)((Object)this.outService.selectById(outEntity.getId()));
            for (OutDetailEntity outDetailEntity : outEntity1.getOutDetailEntityList()) {
                PickingVO pickingVO = new PickingVO();
                pickingVO.setProjectName(outEntity1.getProjectName());
                pickingVO.setOutCode(outEntity1.getBillCode());
                pickingVO.setWarehouseName(outEntity1.getStoreName());
                switch (outEntity1.getCoseFlag()) {
                    case 3: {
                        pickingVO.setPickingFlag(1);
                        pickingVO.setPickingOrgName(outEntity1.getOrgName());
                        pickingVO.setPickingUserName(outEntity1.getPickingName());
                        break;
                    }
                    case 4: {
                        pickingVO.setPickingFlag(0);
                        pickingVO.setPickingOrgName("\u4e2d\u5efa\u4e94\u5c40");
                    }
                }
                pickingVO.setPickingDate(outEntity1.getDeliveryDate());
                pickingVO.setMaterialName(outDetailEntity.getMaterialName());
                pickingVO.setSpec(outDetailEntity.getMaterialSpec());
                pickingVO.setUnit(outDetailEntity.getMaterialUnitName());
                pickingVO.setApplyNum(outDetailEntity.getOutNumber());
                pickingVO.setOutNum(outDetailEntity.getDeliveryNumber());
                pickingVO.setOutAveragePrice(outDetailEntity.getInventoryPrice());
                pickingVO.setOutTaxMny(outDetailEntity.getSurplusTaxMny());
                pickingVO.setOutUserName(outEntity1.getDeliveryName());
                pickingVOList.add(pickingVO);
                pickingVO.setId(outDetailEntity.getId());
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(pickingVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Picking-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPickingData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<PickingVO>> refPickingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PickingVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

