/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.bean.WarehouseFlowEntity;
import com.ejianc.business.storecloud.bean.WarehouseInoutEntity;
import com.ejianc.business.storecloud.mapper.WarehouseFlowMapper;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.service.IWarehouseInoutService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="warehouseFlowService")
public class WarehouseFlowServiceImpl
extends BaseServiceImpl<WarehouseFlowMapper, WarehouseFlowEntity>
implements IWarehouseFlowService {
    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;
    @Autowired
    private IWarehouseService warehouseService;
    @Autowired
    private IWarehouseInoutService warehouseInoutService;

    @Override
    public CommonResponse<String> push(WarehouseManageVO manageVO) {
        List flowVOList = manageVO.getFlowVOList();
        if (null == manageVO.getType() || 2 != manageVO.getType()) {
            List detailPkList = flowVOList.stream().map(WarehouseFlowVO::getSourceDetailId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(WarehouseFlowEntity::getSourceDetailId, detailPkList);
            if (this.count((Wrapper)queryWrapper) > 0) {
                return CommonResponse.success((String)"\u4ed3\u5e93\u5165\u5e93\u6d41\u6c34\u91cd\u590d\u6821\u9a8c\uff1a\u5df2\u5b58\u5728\u8be5\u5355\u636e\u5165\u5e93\u6d41\u6c34\uff01");
            }
        }
        List flowEntityList = BeanMapper.mapList((Iterable)flowVOList, WarehouseFlowEntity.class);
        this.saveOrUpdateBatch(flowEntityList);
        CommonResponse<String> surplusResponse = null;
        if (1 == ((WarehouseFlowVO)flowVOList.get(0)).getInOutFlag()) {
            surplusResponse = this.warehouseSurplusService.updateStoreSurplusIn(manageVO, true);
        } else {
            surplusResponse = this.warehouseSurplusService.updateStoreSurplusOut(manageVO);
            if (!surplusResponse.isSuccess()) {
                return surplusResponse;
            }
            surplusResponse = this.warehouseInoutService.updateInout(flowEntityList, true);
        }
        return surplusResponse.isSuccess() ? CommonResponse.success((String)"\u63d2\u5165\u6d41\u6c34\u6210\u529f") : surplusResponse;
    }

    @Override
    public CommonResponse<String> rollBack(WarehouseManageVO manageVO) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(WarehouseFlowEntity::getSourceDetailId, (Collection)manageVO.getDelDetailIdList());
        List flowEntities = this.list((Wrapper)queryWrapper);
        List flowVOList = BeanMapper.mapList((Iterable)flowEntities, WarehouseFlowVO.class);
        for (WarehouseFlowVO flowVO : flowVOList) {
            flowVO.setMny(ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getMny()));
            flowVO.setTaxMny(ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getTaxMny()));
            flowVO.setNum(ComputeUtil.convertToMinusNumber((BigDecimal)flowVO.getNum()));
        }
        manageVO.setFlowVOList(flowVOList);
        CommonResponse<String> surplusResponse = null;
        if (1 == ((WarehouseFlowEntity)((Object)flowEntities.get(0))).getInOutFlag()) {
            List flowIdList = flowEntities.stream().map(BaseEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(WarehouseInoutEntity::getInFlowId, flowIdList);
            if (this.warehouseInoutService.count((Wrapper)wrapper) > 0) {
                throw new BusinessException("\u8868\u4f53\u542b\u6709\u5df2\u51fa\u5e93\u7269\u8d44\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
            surplusResponse = this.warehouseSurplusService.updateStoreSurplusIn(manageVO, false);
        } else {
            surplusResponse = this.warehouseSurplusService.updateStoreSurplusOut(manageVO);
            if (!surplusResponse.isSuccess()) {
                return surplusResponse;
            }
            surplusResponse = this.warehouseInoutService.updateInout(flowEntities, false);
        }
        this.remove((Wrapper)queryWrapper);
        return surplusResponse.isSuccess() ? CommonResponse.success((String)"\u5220\u9664\u6d41\u6c34\u6210\u529f") : surplusResponse;
    }

    @Override
    public WarehouseFlowVO saveFlow(WarehouseFlowVO flowVO) {
        Long id = IdWorker.getId();
        WarehouseEntity warehouseEntity = (WarehouseEntity)((Object)this.warehouseService.selectById(flowVO.getStoreId()));
        WarehouseFlowEntity entity = (WarehouseFlowEntity)((Object)BeanMapper.map((Object)flowVO, WarehouseFlowEntity.class));
        entity.setId(id);
        entity.setBillDate(new Date());
        entity.setProjectId(warehouseEntity.getProjectId());
        entity.setProjectName(warehouseEntity.getProjectName());
        entity.setParentOrgId(warehouseEntity.getParentOrgId());
        entity.setParentOrgCode(warehouseEntity.getParentOrgCode());
        entity.setParentOrgName(warehouseEntity.getParentOrgName());
        entity.setOrgId(warehouseEntity.getOrgId());
        entity.setOrgName(warehouseEntity.getOrgName());
        entity.setStoreName(warehouseEntity.getWarehouseName());
        entity.setInOutFlag(1);
        entity.setInOutType(1);
        entity.setInOutTypeName("\u671f\u521d\u5165\u5e93");
        entity.setTaxPrice(ComputeUtil.safeDiv((BigDecimal)entity.getTaxMny(), (BigDecimal)entity.getNum()));
        entity.setSourceBillCode(String.valueOf(id));
        entity.setSourceBillDate(new Date());
        entity.setSourceBillTypeCode("EJCBT202208000016");
        entity.setSourceBillTypeName("\u4ed3\u5e93\u6d41\u6c34");
        entity.setSourceDetailId(id);
        entity.setSourceId(id);
        entity.setSourceType(0);
        this.saveOrUpdate((Object)entity);
        WarehouseFlowVO warehouseFlowVO = (WarehouseFlowVO)BeanMapper.map((Object)((Object)entity), WarehouseFlowVO.class);
        WarehouseManageVO manageVO = new WarehouseManageVO();
        manageVO.setProjectId(entity.getProjectId());
        manageVO.setStoreId(entity.getStoreId());
        manageVO.setInOutFlag(entity.getInOutFlag());
        manageVO.setFlowVOList(Arrays.asList(warehouseFlowVO));
        this.warehouseSurplusService.updateStoreSurplusIn(manageVO, true);
        return warehouseFlowVO;
    }
}

