package com.ejianc.business.storecloud.controller;

import java.io.Serializable;

import com.alibaba.fastjson.JSON;
import com.ejianc.business.storecloud.bean.OutDetailEntity;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.storecloud.bean.OutEntity;
import com.ejianc.business.storecloud.service.IOutService;
import com.ejianc.business.storecloud.vo.OutVO;
/**
 * 内部领料出库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("out")
public class OutController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IWarehouseFlowService warehouseFlowService;

    private static final String BILL_CODE = "LING_LIAO";//此处需要根据实际修改

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutService service;

    @Autowired
    private IOutService outService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutVO> saveOrUpdate(@RequestBody OutVO saveOrUpdateVO) {
    	OutEntity entity = BeanMapper.map(saveOrUpdateVO, OutEntity.class);
    	entity.setTenantId(InvocationInfoProxy.getTenantid());
    	entity.setOrgId(InvocationInfoProxy.getOrgId());
        CommonResponse<OrgVO> orgVo = iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        entity.setOrgCode(orgVo.getData().getCode());
        entity.setOrgName(orgVo.getData().getName());
        if (orgVo.getData().getParentId()!=null){
            entity.setParentOrgId(orgVo.getData().getParentId());
        }else {
            entity.setParentOrgId(InvocationInfoProxy.getOrgId());
        }
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE,InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //计算
        BigDecimal deliveryTaxMny = new BigDecimal(0);
        for(OutDetailEntity outDetailEntity : entity.getOutDetailEntityList()){
            deliveryTaxMny = ComputeUtil.safeAdd(deliveryTaxMny,ComputeUtil.safeMultiply(outDetailEntity.getDeliveryNumber(),outDetailEntity.getSurplusTaxPrice()));
        }
        entity.setDeliveryTaxMny(deliveryTaxMny);
        service.saveOrUpdate(entity, false);
    	OutVO vo = BeanMapper.map(entity, OutVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutVO> queryDetail(Long id) {
        logger.info("======================================id====================================== id:"+ id);
    	OutEntity entity = service.selectById(id);
        logger.info("======================================entity====================================== entity:"+ JSON.toJSONString(entity));
    	OutVO vo = BeanMapper.map(entity, OutVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description scanOut 扫码出库跳转详情
     * @param id
     */
    @RequestMapping(value = "/scanOut", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutVO> scanOut(Long id) {
        OutVO outVO = service.scanOut(id);
        return CommonResponse.success("查询详情数据成功！",outVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutVO> vos) {
        service.removeByIds(vos.stream().map(OutVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        if( param.getParams().get("billState") != null){
            param.getParams().put("billState", new Parameter(QueryParam.EQ, param.getParams().get("billState").getValue()));
        }else{
            List<Integer> billState = new ArrayList<>();
            billState.add(1);
            billState.add(3);
            param.getParams().put("billState", new Parameter(QueryParam.IN, billState));
        }
        IPage<OutEntity> page = service.queryPage(param,false);
        IPage<OutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialDelivery-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutVO>> refMaterialDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutEntity> page = service.queryPage(param,false);
        IPage<OutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
