package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.*;
import com.ejianc.business.storecloud.service.IApplyService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.ApplyVO;
import com.ejianc.business.storecloud.vo.OutVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.storecloud.mapper.OutMapper;
import com.ejianc.business.storecloud.service.IOutService;
import java.util.ArrayList;
import java.util.List;

/**
 * 领料出库
 *
 * @author generator
 *
 */
@Service("outService")
public class OutServiceImpl extends BaseServiceImpl<OutMapper, OutEntity> implements IOutService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApplyService applyService;

    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;


    @Override
    public OutVO scanOut(Long id) {
        //根据id查询领料申请单
        ApplyEntity applyEntity = applyService.selectById(id);
        OutVO outVO = new OutVO();
        if(applyEntity!= null){
            ApplyVO applyVO = BeanMapper.map(applyEntity, ApplyVO.class);
            outVO = BeanMapper.map(applyVO, OutVO.class);
            outVO.setId(null);
            outVO.setCreateTime(null);
            outVO.setUpdateTime(null);
            outVO.setBillCode(null);
            outVO.setCreateUserCode(null);
            outVO.setVersion(1);
            outVO.setBillState(0);
            outVO.setStoreName(applyEntity.getStoreName());
            outVO.setApplyForDate(applyVO.getApplyForDate());
            List<ApplyDetailEntity> applyDetailEntityList = applyEntity.getApplyDetailEntityList();
            List<OutDetailEntity> outDetailEntityList = new ArrayList<>();
            for(ApplyDetailEntity applyDetailEntity :applyDetailEntityList){
                OutDetailEntity outDetailEntity = BeanMapper.map(applyDetailEntity, OutDetailEntity.class);
                outDetailEntity.setOutId(null);
                outDetailEntity.setOutNumber(applyDetailEntity.getApplyNumber());
                outDetailEntity.setDeliveryNumber(applyDetailEntity.getApplyNumber());
                outDetailEntity.setApplyDetailId(applyDetailEntity.getId());
                outDetailEntity.setId(null);
                outDetailEntity.setMemo(null);
                //根据仓库，物料查询仓库明细
                LambdaQueryWrapper<WarehouseSurplusEntity> queryWrapper = new LambdaQueryWrapper<WarehouseSurplusEntity>();
                queryWrapper.eq(WarehouseSurplusEntity::getMaterialId, applyDetailEntity.getMaterialId());
                queryWrapper.eq(WarehouseSurplusEntity::getStoreId, applyEntity.getStoreId());
                WarehouseSurplusEntity warehouseSurplusEntity = warehouseSurplusService.getOne(queryWrapper);
                if(warehouseSurplusEntity != null){
                    outDetailEntity.setSurplusNum(warehouseSurplusEntity.getSurplusNum());//库存余量
                    outDetailEntity.setInventoryPrice(warehouseSurplusEntity.getSurplusTaxPrice());// // 库存单价
                    outDetailEntity.setSurplusTaxMny(warehouseSurplusEntity.getSurplusTaxMny());// // 库存金额含税
                }
                outDetailEntityList.add(outDetailEntity);
            }
            outVO.setOutDetailEntityList(outDetailEntityList);

        }else{
            logger.info("----------------扫码出库跳转详情outVO查询数据为空------------------");
        }
        return outVO;

    }
}
