package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.bean.WarehouseFlowEntity;
import com.ejianc.business.storecloud.bean.WarehouseInoutEntity;
import com.ejianc.business.storecloud.enums.InOutFlagEnum;
import com.ejianc.business.storecloud.enums.InOutTypeEnum;
import com.ejianc.business.storecloud.mapper.WarehouseFlowMapper;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.service.IWarehouseInoutService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 仓库入出流水表
 *
 * @author generator
 *
 */
@Service("warehouseFlowService")
public class WarehouseFlowServiceImpl extends BaseServiceImpl<WarehouseFlowMapper, WarehouseFlowEntity> implements IWarehouseFlowService {

    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;

    @Autowired
    private IWarehouseService warehouseService;

    @Autowired
    private IWarehouseInoutService warehouseInoutService;

    @Override
    public CommonResponse<String> push(WarehouseManageVO manageVO) {
        List<WarehouseFlowVO> flowVOList = manageVO.getFlowVOList();
        if(null == manageVO.getType() || 2 != manageVO.getType()){
            List<Long> detailPkList = flowVOList.stream().map(WarehouseFlowVO::getSourceDetailId).collect(Collectors.toList());
            LambdaQueryWrapper<WarehouseFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.in(WarehouseFlowEntity::getSourceDetailId, detailPkList);
            if(count(queryWrapper) > 0){
                return CommonResponse.success("仓库入库流水重复校验：已存在该单据入库流水！");
            }
        }
        List<WarehouseFlowEntity> flowEntityList = BeanMapper.mapList(flowVOList, WarehouseFlowEntity.class);
        saveOrUpdateBatch(flowEntityList);
        CommonResponse<String> surplusResponse = null;
        if (InOutFlagEnum.入库.getCode().equals(flowVOList.get(0).getInOutFlag())) {
            surplusResponse = warehouseSurplusService.updateStoreSurplusIn(manageVO, true);
        } else {
            surplusResponse = warehouseSurplusService.updateStoreSurplusOut(manageVO);
            if (!surplusResponse.isSuccess()) {
                return surplusResponse;
            }
            surplusResponse = warehouseInoutService.updateInout(flowEntityList, true);
        }
        return  surplusResponse.isSuccess() ? CommonResponse.success("插入流水成功") : surplusResponse;
    }

    @Override
    public CommonResponse<String> rollBack(WarehouseManageVO manageVO) {
        LambdaQueryWrapper<WarehouseFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(WarehouseFlowEntity::getSourceDetailId, manageVO.getDelDetailIdList());
        List<WarehouseFlowEntity> flowEntities = list(queryWrapper);
        List<WarehouseFlowVO> flowVOList = BeanMapper.mapList(flowEntities, WarehouseFlowVO.class);
        for(WarehouseFlowVO flowVO : flowVOList){
            flowVO.setMny(ComputeUtil.convertToMinusNumber(flowVO.getMny()));
            flowVO.setTaxMny(ComputeUtil.convertToMinusNumber(flowVO.getTaxMny()));
            flowVO.setNum(ComputeUtil.convertToMinusNumber(flowVO.getNum()));
        }
        manageVO.setFlowVOList(flowVOList);

        CommonResponse<String> surplusResponse = null;
        if (InOutFlagEnum.入库.getCode().equals(flowEntities.get(0).getInOutFlag())) {
            List<Long> flowIdList = flowEntities.stream().map(WarehouseFlowEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<WarehouseInoutEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(WarehouseInoutEntity::getInFlowId, flowIdList);
            if (warehouseInoutService.count(wrapper) > 0) {
                throw new BusinessException("表体含有已出库物资，不允许删除!");
            }
            surplusResponse = warehouseSurplusService.updateStoreSurplusIn(manageVO, false);
        } else {
            surplusResponse = warehouseSurplusService.updateStoreSurplusOut(manageVO);
            if (!surplusResponse.isSuccess()) {
                return surplusResponse;
            }
            surplusResponse = warehouseInoutService.updateInout(flowEntities, false);
        }
        remove(queryWrapper);
        return surplusResponse.isSuccess() ? CommonResponse.success("删除流水成功") : surplusResponse;
    }

    @Override
    public WarehouseFlowVO saveFlow(WarehouseFlowVO flowVO) {
        Long id = IdWorker.getId();
        WarehouseEntity warehouseEntity = warehouseService.selectById(flowVO.getStoreId());
        WarehouseFlowEntity entity = BeanMapper.map(flowVO, WarehouseFlowEntity.class);
        entity.setId(id);
        entity.setBillDate(new Date());
        entity.setProjectId(warehouseEntity.getProjectId());
        entity.setProjectName(warehouseEntity.getProjectName());
        entity.setParentOrgId(warehouseEntity.getParentOrgId());
        entity.setParentOrgCode(warehouseEntity.getParentOrgCode());
        entity.setParentOrgName(warehouseEntity.getParentOrgName());
        entity.setOrgId(warehouseEntity.getOrgId());
        entity.setOrgName(warehouseEntity.getOrgName());
        entity.setStoreName(warehouseEntity.getWarehouseName());
        entity.setInOutFlag(InOutFlagEnum.入库.getCode());
        entity.setInOutType(InOutTypeEnum.期初入库.getCode());
        entity.setInOutTypeName("期初入库");
        entity.setTaxPrice(ComputeUtil.safeDiv(entity.getTaxMny(), entity.getNum()));
        entity.setSourceBillCode(String.valueOf(id));
        entity.setSourceBillDate(new Date());
        entity.setSourceBillTypeCode("EJCBT202208000016");
        entity.setSourceBillTypeName("仓库流水");
        entity.setSourceDetailId(id);
        entity.setSourceId(id);
        entity.setSourceType(0);
        saveOrUpdate(entity);
        WarehouseFlowVO warehouseFlowVO = BeanMapper.map(entity, WarehouseFlowVO.class);
        WarehouseManageVO manageVO = new WarehouseManageVO();
        manageVO.setProjectId(entity.getProjectId());
        manageVO.setStoreId(entity.getStoreId());
        manageVO.setInOutFlag(entity.getInOutFlag());
        manageVO.setFlowVOList(Arrays.asList(warehouseFlowVO));
        warehouseSurplusService.updateStoreSurplusIn(manageVO, true);
        return warehouseFlowVO;
    }
}
