package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.mapper.WarehouseSurplusMapper;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 仓库存量表
 *
 * @author generator
 *
 */
@Service("warehouseSurplusService")
public class WarehouseSurplusServiceImpl extends BaseServiceImpl<WarehouseSurplusMapper, WarehouseSurplusEntity> implements IWarehouseSurplusService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

    @Autowired
    private IMaterialApi materialApi;

    @Override
    public CommonResponse<String> updateStoreSurplusIn(WarehouseManageVO manageVO, boolean isSave) {
        Integer type = manageVO.getType() == null ? -1 : manageVO.getType();
        List<WarehouseFlowVO> flowVOList = manageVO.getFlowVOList();
        List<Long> materialList = flowVOList.stream().map(WarehouseFlowVO::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper<WarehouseSurplusEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WarehouseSurplusEntity::getProjectId, manageVO.getProjectId());
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, manageVO.getStoreId());
        queryWrapper.in(WarehouseSurplusEntity::getMaterialId, materialList);
        List<WarehouseSurplusEntity> surplusEntities = list(queryWrapper);
        Map<Long, WarehouseSurplusEntity> surplusMap = null;
        if(CollectionUtils.isNotEmpty(surplusEntities)){
            surplusMap = surplusEntities.stream().collect(Collectors.toMap(WarehouseSurplusEntity::getMaterialId, Function.identity(), (key1, key2) -> key2));
        }else{
            surplusMap = new HashMap<>();
        }
        for(WarehouseFlowVO warehouseFlowVO : flowVOList) {
            WarehouseSurplusEntity surplusEntity = null;
            if (surplusMap.containsKey(warehouseFlowVO.getMaterialId())) {
                surplusEntity = surplusMap.get(warehouseFlowVO.getMaterialId());
            } else {
                surplusEntity = BeanMapper.map(warehouseFlowVO, WarehouseSurplusEntity.class);
                surplusEntity.setAttachIds(null);
                surplusEntity.setId(IdWorker.getId());
                CommonResponse<MaterialCategoryVO> commonResponse = materialApi.queryCategoryById(surplusEntity.getMaterialCategoryId());
                if(commonResponse.isSuccess() && null != commonResponse.getData()){
                    surplusEntity.setMaterialCategoryInnerCode(commonResponse.getData().getInnerCode());
                }
            }

            surplusEntity.setInstoreMny(ComputeUtil.safeAdd(surplusEntity.getInstoreMny(), warehouseFlowVO.getMny()));
            surplusEntity.setInstoreTaxMny(ComputeUtil.safeAdd(surplusEntity.getInstoreTaxMny(), warehouseFlowVO.getTaxMny()));
            if (!(isSave && 2 == type)) {
                surplusEntity.setInstoreNum(ComputeUtil.safeAdd(surplusEntity.getInstoreNum(), warehouseFlowVO.getNum()));
            }
            surplusEntity.setSurplusMny(ComputeUtil.safeSub(surplusEntity.getInstoreMny(), surplusEntity.getOutLockMny()));
            surplusEntity.setSurplusTaxMny(ComputeUtil.safeSub(surplusEntity.getInstoreTaxMny(), surplusEntity.getOutLockTaxMny()));
            surplusEntity.setSurplusNum(ComputeUtil.safeSub(surplusEntity.getInstoreNum(), surplusEntity.getOutLockNum()));
            if (ComputeUtil.isLessThan(surplusEntity.getInstoreNum(), surplusEntity.getOutLockNum())) {
                throw new BusinessException("物资【" + warehouseFlowVO.getMaterialName() + "】已出库，不允许删除!");
            }
            surplusEntity.setSurplusPrice(ComputeUtil.safeDiv(surplusEntity.getSurplusMny(), surplusEntity.getSurplusNum()));
            surplusEntity.setSurplusTaxPrice(ComputeUtil.safeDiv(surplusEntity.getSurplusTaxMny(), surplusEntity.getSurplusNum()));
            surplusMap.put(warehouseFlowVO.getMaterialId(), surplusEntity);

            if (isSave && 2 != type) {
                switch (warehouseFlowVO.getInOutType()) {
                    case 1:
                        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(warehouseFlowVO.getSourceDetailId()),
                                "EJCBT202208000016", "imgUpload",
                                String.valueOf(surplusEntity.getId()), "EJCBT202208000017", "imgUpload");
                        break;
                    case 2:
                        attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(warehouseFlowVO.getSourceDetailId()),
                                "BT210816000000002", "imgUpload",
                                String.valueOf(surplusEntity.getId()), "EJCBT202208000017", "imgUpload");
                        break;
                    default:
                        break;
                }

                CommonResponse<List<AttachmentVO>> commonResponse = attachmentApi.queryListBySourceId(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", null);
                if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty(commonResponse.getData())) {
                    List<Long> fileIdList = commonResponse.getData().stream().map(AttachmentVO::getId).collect(Collectors.toList());
                    surplusEntity.setFileIds(StringUtils.join(fileIdList, ","));
                }
            }
        }
        if (!surplusMap.isEmpty()) {
            saveOrUpdateBatch(surplusMap.values());
        }
        return CommonResponse.success("更新库存余量成功");
    }

    @Override
    public CommonResponse<String> updateStoreSurplusOut(WarehouseManageVO manageVO) {
        List<WarehouseFlowVO> flowVOList = manageVO.getFlowVOList();
        List<Long> materialList = flowVOList.stream().map(WarehouseFlowVO::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper<WarehouseSurplusEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WarehouseSurplusEntity::getProjectId, manageVO.getProjectId());
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, manageVO.getStoreId());
        queryWrapper.in(WarehouseSurplusEntity::getMaterialId, materialList);
        List<WarehouseSurplusEntity> surplusEntities = list(queryWrapper);
        Map<Long, WarehouseSurplusEntity> surplusMap = null;
        if(CollectionUtils.isNotEmpty(surplusEntities)){
            surplusMap = surplusEntities.stream().collect(Collectors.toMap(WarehouseSurplusEntity::getMaterialId, Function.identity(), (key1, key2) -> key2));
        }else{
            surplusMap = new HashMap<>();
        }
        for(WarehouseFlowVO warehouseFlowVO : flowVOList) {
            WarehouseSurplusEntity surplusEntity = null;
            if (surplusMap.containsKey(warehouseFlowVO.getMaterialId())) {
                surplusEntity = surplusMap.get(warehouseFlowVO.getMaterialId());
            } else {
                throw new BusinessException("物资【" + warehouseFlowVO.getMaterialName() + "】没有入库!");
            }
            surplusEntity.setOutLockMny(ComputeUtil.safeAdd(surplusEntity.getOutLockMny(), warehouseFlowVO.getMny()));
            surplusEntity.setOutLockTaxMny(ComputeUtil.safeAdd(surplusEntity.getOutLockTaxMny(), warehouseFlowVO.getTaxMny()));
            surplusEntity.setOutLockNum(ComputeUtil.safeAdd(surplusEntity.getOutLockNum(), warehouseFlowVO.getNum()));
            if (ComputeUtil.isLessThan(surplusEntity.getInstoreNum(), surplusEntity.getOutLockNum())) {
                throw new BusinessException("物资【" + warehouseFlowVO.getMaterialName() + "】库存不足!");
//                return CommonResponse.error("物资【" + warehouseFlowVO.getMaterialName() + "】已出库，不允许删除!");
            }
            surplusEntity.setSurplusMny(ComputeUtil.safeSub(surplusEntity.getInstoreMny(), surplusEntity.getOutLockMny()));
            surplusEntity.setSurplusTaxMny(ComputeUtil.safeSub(surplusEntity.getInstoreTaxMny(), surplusEntity.getOutLockTaxMny()));
            surplusEntity.setSurplusNum(ComputeUtil.safeSub(surplusEntity.getInstoreNum(), surplusEntity.getOutLockNum()));
            surplusEntity.setSurplusPrice(ComputeUtil.safeDiv(surplusEntity.getSurplusMny(), surplusEntity.getSurplusNum()));
            surplusEntity.setSurplusTaxPrice(ComputeUtil.safeDiv(surplusEntity.getSurplusTaxMny(), surplusEntity.getSurplusNum()));
            surplusMap.put(warehouseFlowVO.getMaterialId(), surplusEntity);
        }
        if (!surplusMap.isEmpty()) {
            saveOrUpdateBatch(surplusMap.values());
        }
        return CommonResponse.success("更新库存余量成功");
    }
}
