/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.service.IMaterialOrgService;
import com.ejianc.business.storecloud.vo.MaterialOrgVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"materialOrg"})
public class MaterialOrgController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired(required=false)
    private RestHighLevelClient client;
    private static final String INDEX_NAME_MATERIAL_CATEGORY = "ejc_material_report_material_category";
    private static final Integer QUERY_TIMEOUT = 60;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IMaterialOrgService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<MaterialOrgVO>> saveOrUpdate(@RequestBody List<MaterialOrgVO> saveOrUpdateVO) {
        List<MaterialOrgVO> vo = this.service.saveOrUpdate(saveOrUpdateVO);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<MaterialOrgVO> queryDetail(Long id) {
        MaterialOrgEntity entity = (MaterialOrgEntity)((Object)this.service.selectById(id));
        MaterialOrgVO vo = (MaterialOrgVO)BeanMapper.map((Object)((Object)entity), MaterialOrgVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialOrgVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (MaterialOrgVO materialOrgVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<MaterialOrgVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("spec");
        if (param.getParams().size() != 0 && param.getParams().get("categoryId") != null) {
            param.getParams().put("categoryInnerCode", new Parameter("like", ((Parameter)param.getParams().get("categoryId")).getValue()));
            param.getParams().remove("categoryId");
        }
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("eq", (Object)InvocationInfoProxy.getOrgId()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialOrgVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialOrg-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refMaterialOrgData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<MaterialOrgVO>> refMaterialOrgData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), MaterialOrgVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/lazyMaterialCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(Long parentId) {
        ArrayList<MaterialCategoryVO> materialCategoryVO;
        block5: {
            materialCategoryVO = new ArrayList<MaterialCategoryVO>();
            ArrayList<Long> list = new ArrayList<Long>();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getDr, (Object)0);
            queryWrapper.eq(MaterialOrgEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
            queryWrapper.like(parentId != null, MaterialOrgEntity::getCategoryInnerCode, (Object)parentId);
            List materialOrgEntities = this.service.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty((Collection)materialOrgEntities)) break block5;
            for (MaterialOrgEntity materialOrgEntity : materialOrgEntities) {
                list.add(materialOrgEntity.getCategoryId());
            }
            CommonResponse materialCategoryVOS = this.materialApi.queryCategoryListByChildren(list);
            List dateList = (List)materialCategoryVOS.getData();
            if (parentId != null) {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() == null || !materialCategoryVO1.getParentId().equals(parentId)) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            } else {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() != null) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }
}

