/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.PersionProjectEntity;
import com.ejianc.business.storecloud.enums.WechatErrorEnum;
import com.ejianc.business.storecloud.service.impl.PersionProjectServiceImpl;
import com.ejianc.business.storecloud.utils.MD5Utils;
import com.ejianc.business.storecloud.utils.WeChatUtil;
import com.ejianc.business.storecloud.vo.PersionProjectVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"wechat"})
public class WechatController
implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private IThirdSystemApi thirdSystemApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private PersionProjectServiceImpl persionProjectService;

    @RequestMapping(value={"/openId"}, method={RequestMethod.GET})
    @ResponseBody
    public Map openId(@RequestParam(value="code") String code) {
        return this.weChatUtil.oauth2GetOpenid(code);
    }

    @RequestMapping(value={"no_auth/anaLogin"}, method={RequestMethod.POST})
    @ResponseBody
    private Map anaLogin(@RequestBody PersionProjectVO persionVO, HttpServletRequest request) {
        Map<String, String> map;
        block5: {
            map = this.weChatUtil.oauth2GetOpenid(persionVO.getWechatCode());
            CommonResponse thirdSystemVO = this.thirdSystemApi.getOneByCode("ZJWJ");
            this.logger.info("thirdSystemVO " + JSONObject.toJSONString((Object)thirdSystemVO.getData()));
            try {
                if (thirdSystemVO.isSuccess() && thirdSystemVO.getData() != null) {
                    HashMap<String, Long> params = new HashMap<String, Long>();
                    params.put("tenantId", ((ThirdSystemVO)thirdSystemVO.getData()).getTenantId());
                    this.logger.info("baseHost " + this.baseHost);
                    String back = HttpTookit.get((String)(this.baseHost + "ejc-idm-web/user/context/getBytenantid"), params, (HttpServletRequest)request);
                    String authority = "";
                    JSONObject jsonBack = JSONObject.parseObject((String)back);
                    if (jsonBack.get((Object)"data") != null) {
                        JSONObject data = (JSONObject)jsonBack.get((Object)"data");
                        this.logger.info("data  " + data.toJSONString());
                        if (data.get((Object)"userContext") != null) {
                            JSONObject userContext = (JSONObject)data.get((Object)"userContext");
                            authority = "userType=" + userContext.getString("userType") + ";userCode=" + userContext.getString("userCode") + ";orgId=" + userContext.getString("orgId") + ";tenantid=" + userContext.getString("tenantid") + ";token=" + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints") + ";u_usercode=" + userContext.getString("u_usercode") + ";userId=" + userContext.getString("userId");
                            map.put("authority", authority);
                        }
                    }
                    break block5;
                }
                throw new BusinessException("\u6839\u636e\u7cfb\u7edfcode\uff1aZJWJ\u83b7\u53d6\u7b2c\u4e09\u65b9\u7cfb\u7edf\u4fe1\u606f\u5931\u8d25");
            }
            catch (Exception e) {
                this.logger.info(e.getMessage());
            }
        }
        return map;
    }

    @RequestMapping(value={"/wechatlogin"}, method={RequestMethod.POST})
    @ResponseBody
    private CommonResponse<PersionProjectVO> wechatlogin(@RequestBody PersionProjectVO persionVO, HttpServletRequest request) {
        this.logger.info("wechatlogin : openid" + persionVO.getOpenId());
        if (StringUtils.isBlank((CharSequence)persionVO.getOpenId())) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38,\u672a\u83b7\u53d6openid\uff01");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PersionProjectEntity::getOpenId, (Object)persionVO.getOpenId());
        wrapper.eq(PersionProjectEntity::getBindStatus, (Object)1);
        PersionProjectEntity persionProjectEntity = (PersionProjectEntity)((Object)this.persionProjectService.getOne((Wrapper)wrapper));
        if (null == persionProjectEntity) {
            return CommonResponse.error((int)WechatErrorEnum.OPENID\u672a\u7ed1\u5b9a.getCode(), (String)"OPENID\u672a\u7ed1\u5b9a");
        }
        if (persionProjectEntity.getFirstFlag().booleanValue()) {
            return CommonResponse.error((int)WechatErrorEnum.\u521d\u6b21\u767b\u5f55.getCode(), (String)"\u521d\u6b21\u767b\u5f55\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801");
        }
        PersionProjectVO persionProjectVO = (PersionProjectVO)BeanMapper.map((Object)((Object)persionProjectEntity), PersionProjectVO.class);
        return CommonResponse.success((String)"\u767b\u5f55\u6210\u529f", (Object)persionProjectVO);
    }

    @RequestMapping(value={"/bindWechat"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PersionProjectVO> bindWechat(@RequestBody PersionProjectVO persionProjectVO, HttpServletRequest request) {
        if (StringUtils.isBlank((CharSequence)persionProjectVO.getOpenId())) {
            throw new BusinessException("\u7cfb\u7edf\u5f02\u5e38,\u672a\u83b7\u53d6openid\uff01");
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PersionProjectEntity::getUserName, (Object)persionProjectVO.getUserName());
        PersionProjectEntity persionProjectEntity = (PersionProjectEntity)((Object)this.persionProjectService.getOne((Wrapper)wrapper));
        if (null == persionProjectEntity) {
            return CommonResponse.error((int)WechatErrorEnum.\u8d26\u53f7\u4e0d\u5b58\u5728.getCode(), (String)"\u8d26\u53f7\u4e0d\u5b58\u5728");
        }
        if (!persionProjectEntity.getUserPwd().equals(MD5Utils.getStringMD5(persionProjectVO.getUserPwd()))) {
            return CommonResponse.error((int)WechatErrorEnum.\u5bc6\u7801\u9519\u8bef.getCode(), (String)"\u5bc6\u7801\u9519\u8bef");
        }
        if (0 == persionProjectEntity.getEnabled()) {
            return CommonResponse.error((int)WechatErrorEnum.\u8be5\u7528\u6237\u5df2\u505c\u7528.getCode(), (String)"\u8be5\u7528\u6237\u5df2\u505c\u7528");
        }
        persionProjectEntity.setBindStatus(1);
        persionProjectEntity.setOpenId(persionProjectVO.getOpenId());
        this.persionProjectService.updateById((Object)persionProjectEntity);
        if (persionProjectEntity.getFirstFlag().booleanValue()) {
            return CommonResponse.error((int)WechatErrorEnum.\u521d\u6b21\u767b\u5f55.getCode(), (String)"\u521d\u6b21\u767b\u5f55\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801");
        }
        persionProjectVO = (PersionProjectVO)BeanMapper.map((Object)((Object)persionProjectEntity), PersionProjectVO.class);
        return CommonResponse.success((String)"\u7ed1\u5b9a\u6210\u529f", (Object)persionProjectVO);
    }
}

