/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.storecloud.bean.ConfigProjectEntity;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.bean.MaterialProjectEntity;
import com.ejianc.business.storecloud.mapper.MaterialProjectMapper;
import com.ejianc.business.storecloud.service.IConfigProjectService;
import com.ejianc.business.storecloud.service.IMaterialOrgService;
import com.ejianc.business.storecloud.service.IMaterialProjectService;
import com.ejianc.business.storecloud.vo.MaterialProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialProjectService")
public class MaterialProjectServiceImpl
extends BaseServiceImpl<MaterialProjectMapper, MaterialProjectEntity>
implements IMaterialProjectService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IConfigProjectService configProjectService;
    @Autowired
    private IMaterialOrgService materialOrgService;
    @Autowired
    private IMaterialApi materialApi;

    @Override
    public List<MaterialProjectVO> saveOrUpdate(List<MaterialProjectVO> saveOrUpdateVO) {
        ArrayList<MaterialProjectVO> vo = new ArrayList<MaterialProjectVO>();
        for (MaterialProjectVO materialProjectVO : saveOrUpdateVO) {
            if (materialProjectVO.getId() != null) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(MaterialProjectEntity::getMaterialId, (Object)materialProjectVO.getId());
                queryWrapper.eq(MaterialProjectEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
                queryWrapper.eq(BaseEntity::getDr, (Object)0);
                List materialProjectEntityList = super.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)materialProjectEntityList)) {
                    throw new BusinessException("\u7f16\u53f7\u4e3a" + materialProjectVO.getCode() + "\u7684" + materialProjectVO.getName() + "\u5df2\u88ab\u5f15\u7528\uff01");
                }
            }
            materialProjectVO.setMaterialId(materialProjectVO.getId());
            materialProjectVO.setMaterialCode(materialProjectVO.getCode());
            materialProjectVO.setMaterialName(materialProjectVO.getName());
            materialProjectVO.setMaterialUnitName(materialProjectVO.getUnitName());
            materialProjectVO.setMaterialSpec(materialProjectVO.getSpec());
            materialProjectVO.setMaterialCategoryId(materialProjectVO.getCategoryId());
            materialProjectVO.setMaterialCategoryName(materialProjectVO.getCategoryName());
            materialProjectVO.setMaterialCategoryCode(materialProjectVO.getCategoryCode());
            CommonResponse materialCategoryVO = this.materialApi.queryCategoryById(materialProjectVO.getCategoryId());
            this.logger.info("innerCode,---------------------------->: {}", (Object)JSONObject.toJSONString((Object)materialCategoryVO.getData()));
            this.logger.info("getCode,---------------------------->: {}", (Object)JSONObject.toJSONString((Object)materialCategoryVO.getCode()));
            this.logger.info("getMsg,---------------------------->: {}", (Object)JSONObject.toJSONString((Object)materialCategoryVO.getMsg()));
            this.logger.info("getInnerCode,---------------------------->: {}", (Object)JSONObject.toJSONString((Object)((MaterialCategoryVO)materialCategoryVO.getData()).getInnerCode()));
            materialProjectVO.setMaterialCategoryInnerCode(((MaterialCategoryVO)materialCategoryVO.getData()).getInnerCode());
            materialProjectVO.setOrgId(InvocationInfoProxy.getOrgId());
            CommonResponse orgVo = this.iOrgApi.detailById(materialProjectVO.getOrgId());
            materialProjectVO.setOrgCode(((OrgVO)orgVo.getData()).getCode());
            materialProjectVO.setOrgName(((OrgVO)orgVo.getData()).getName());
            MaterialProjectEntity entity = (MaterialProjectEntity)((Object)BeanMapper.map((Object)materialProjectVO, MaterialProjectEntity.class));
            entity.setId(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setTenantId(null);
            super.saveOrUpdate((Object)entity, false);
            vo.add((MaterialProjectVO)BeanMapper.map((Object)((Object)entity), MaterialProjectVO.class));
        }
        return vo;
    }

    @Override
    public int synchronization() {
        ConfigProjectEntity configProjectEntity = this.configProjectService.queryConfig(InvocationInfoProxy.getOrgId());
        if (configProjectEntity == null) {
            throw new BusinessException("\u672a\u83b7\u53d6\u5230\u914d\u7f6e\u4fe1\u606f\uff0c\u540c\u6b65\u5931\u8d25 \uff01");
        }
        String innerCode = configProjectEntity.getParentInnerCode();
        String[] strs = innerCode.split("\\|");
        ArrayList<Long> childIds = new ArrayList<Long>();
        for (String id : strs) {
            if (Long.parseLong(id) == InvocationInfoProxy.getOrgId()) continue;
            childIds.add(Long.parseLong(id));
        }
        Collections.reverse(childIds);
        List materialOrgEntityList = new ArrayList();
        for (Long orgId : childIds) {
            LambdaQueryWrapper queryWrappers = new LambdaQueryWrapper();
            queryWrappers.eq(ConfigProjectEntity::getOrgId, (Object)orgId);
            List configProjectEntityList = this.configProjectService.list((Wrapper)queryWrappers);
            if (!CollectionUtils.isNotEmpty((Collection)configProjectEntityList) || ((ConfigProjectEntity)((Object)configProjectEntityList.get(0))).getEnabled() != 1) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(MaterialOrgEntity::getOrgId, (Object)orgId);
            materialOrgEntityList = this.materialOrgService.list((Wrapper)queryWrapper);
            if (!CollectionUtils.isNotEmpty(materialOrgEntityList)) continue;
            break;
        }
        if (CollectionUtils.isNotEmpty(materialOrgEntityList)) {
            for (MaterialOrgEntity materialOrgEntity : materialOrgEntityList) {
                MaterialProjectEntity materialProjectEntity = new MaterialProjectEntity();
                materialProjectEntity.setMaterialId(materialOrgEntity.getMaterialId());
                materialProjectEntity.setMaterialCode(materialOrgEntity.getMaterialCode());
                materialProjectEntity.setMaterialName(materialOrgEntity.getMaterialName());
                materialProjectEntity.setMaterialSpec(materialOrgEntity.getSpec());
                materialProjectEntity.setMaterialUnitName(materialOrgEntity.getUnit());
                materialProjectEntity.setMaterialCategoryId(materialOrgEntity.getCategoryId());
                materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
                materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
                materialProjectEntity.setOrgId(InvocationInfoProxy.getOrgId());
                materialProjectEntity.setMaterialCategoryInnerCode(materialOrgEntity.getCategoryInnerCode());
                CommonResponse parentOrgList = this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
                materialProjectEntity.setOrgCode(((OrgVO)((List)parentOrgList.getData()).get(0)).getCode());
                materialProjectEntity.setParentId(((OrgVO)((List)parentOrgList.getData()).get(0)).getParentId());
                materialProjectEntity.setOrgName(((OrgVO)((List)parentOrgList.getData()).get(0)).getName());
                if (materialOrgEntity.getMaterialId() != null) {
                    LambdaQueryWrapper queryWrappers = new LambdaQueryWrapper();
                    queryWrappers.eq(MaterialProjectEntity::getMaterialId, (Object)materialOrgEntity.getMaterialId());
                    queryWrappers.eq(MaterialProjectEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
                    queryWrappers.eq(BaseEntity::getDr, (Object)0);
                    List materialProjectEntityList = super.list((Wrapper)queryWrappers);
                    if (CollectionUtils.isNotEmpty((Collection)materialProjectEntityList)) continue;
                }
                this.saveOrUpdate((Object)materialProjectEntity);
            }
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.set(ConfigProjectEntity::getInitializeEnabled, (Object)1);
        updateWrapper.set(ConfigProjectEntity::getEnabled, (Object)1);
        updateWrapper.eq(ConfigProjectEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
        boolean flag = this.configProjectService.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BusinessException("\u8bbe\u7f6e\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
        }
        return 0;
    }

    @Override
    public Boolean isCloudMaterial(Long materialId, Long orgId) {
        LambdaQueryWrapper queryWrappesr = new LambdaQueryWrapper();
        queryWrappesr.eq(ConfigProjectEntity::getOrgId, (Object)orgId);
        queryWrappesr.eq(ConfigProjectEntity::getEnabled, (Object)1);
        List configProjectEntityList = this.configProjectService.list((Wrapper)queryWrappesr);
        if (CollectionUtils.isNotEmpty((Collection)configProjectEntityList)) {
            List materialProjectEntityList = new ArrayList();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(MaterialProjectEntity::getOrgId, (Object)orgId);
            queryWrapper.eq(MaterialProjectEntity::getMaterialId, (Object)materialId);
            materialProjectEntityList = this.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty(materialProjectEntityList)) {
                return true;
            }
            CommonResponse parOrg = this.iOrgApi.detailById(orgId);
            List materialOrgEntities = new ArrayList();
            if (parOrg.isSuccess() & null != parOrg.getData()) {
                OrgVO parOrgVO = (OrgVO)parOrg.getData();
                String innerCode = parOrgVO.getInnerCode();
                String[] strs = innerCode.split("\\|");
                ArrayList<Long> childIds = new ArrayList<Long>();
                for (String id : strs) {
                    childIds.add(Long.parseLong(id));
                }
                LambdaQueryWrapper queryWrappers = new LambdaQueryWrapper();
                queryWrappers.in(MaterialOrgEntity::getOrgId, childIds);
                queryWrappers.eq(MaterialOrgEntity::getMaterialId, (Object)materialId);
                materialOrgEntities = this.materialOrgService.list((Wrapper)queryWrappers);
            }
            if (CollectionUtils.isNotEmpty(materialOrgEntities)) {
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public List<Long> isCloudMaterials(List<Long> materialIds, Long orgId) {
        LambdaQueryWrapper queryWrappesr = new LambdaQueryWrapper();
        queryWrappesr.eq(ConfigProjectEntity::getOrgId, (Object)orgId);
        queryWrappesr.eq(ConfigProjectEntity::getEnabled, (Object)1);
        List configProjectEntityList = this.configProjectService.list((Wrapper)queryWrappesr);
        if (CollectionUtils.isNotEmpty((Collection)configProjectEntityList)) {
            ArrayList materialProjectEntityList = new ArrayList();
            ArrayList<Long> cloudMaterialsVOList = new ArrayList<Long>();
            ArrayList<Long> materialIdList = new ArrayList<Long>();
            for (Long materialId : materialIds) {
                LambdaQueryWrapper queryWrappers = new LambdaQueryWrapper();
                queryWrappers.eq(MaterialProjectEntity::getOrgId, (Object)orgId);
                queryWrappers.eq(MaterialProjectEntity::getMaterialId, (Object)materialId);
                List materialProjectEntities = this.list((Wrapper)queryWrappers);
                if (!CollectionUtils.isNotEmpty((Collection)materialProjectEntities)) continue;
                materialProjectEntityList.addAll(materialProjectEntities);
                materialIdList.add(materialId);
            }
            if (CollectionUtils.isNotEmpty(materialProjectEntityList)) {
                for (MaterialProjectEntity materialProjectEntity : materialProjectEntityList) {
                    cloudMaterialsVOList.add(materialProjectEntity.getMaterialId());
                }
            }
            ArrayList<Long> childIds = new ArrayList<Long>();
            CommonResponse parOrg = this.iOrgApi.detailById(orgId);
            if (parOrg.isSuccess() & null != parOrg.getData()) {
                OrgVO parOrgVO = (OrgVO)parOrg.getData();
                String innerCode = parOrgVO.getInnerCode();
                String[] strs = innerCode.split("\\|");
                for (String id : strs) {
                    childIds.add(Long.parseLong(id));
                }
                Collections.reverse(childIds);
            }
            ArrayList materialOrgEntityList = new ArrayList();
            block3: for (Long materialId : materialIds) {
                if (materialIdList.contains(materialId)) continue;
                for (Long orgIdc : childIds) {
                    LambdaQueryWrapper queryWrappers = new LambdaQueryWrapper();
                    queryWrappers.eq(MaterialOrgEntity::getOrgId, (Object)orgIdc);
                    queryWrappers.eq(MaterialOrgEntity::getMaterialId, (Object)materialId);
                    List materialOrgEntities = this.materialOrgService.list((Wrapper)queryWrappers);
                    if (!CollectionUtils.isNotEmpty((Collection)materialOrgEntities)) continue;
                    materialOrgEntityList.addAll(materialOrgEntities);
                    continue block3;
                }
            }
            if (CollectionUtils.isNotEmpty(materialOrgEntityList)) {
                for (MaterialOrgEntity materialOrgEntity : materialOrgEntityList) {
                    cloudMaterialsVOList.add(materialOrgEntity.getMaterialId());
                }
            }
            return cloudMaterialsVOList;
        }
        return null;
    }
}

