/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.mapper.WarehouseSurplusMapper;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="warehouseSurplusService")
public class WarehouseSurplusServiceImpl
extends BaseServiceImpl<WarehouseSurplusMapper, WarehouseSurplusEntity>
implements IWarehouseSurplusService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IWarehouseService warehouseService;

    @Override
    public CommonResponse<String> updateStoreSurplusIn(WarehouseManageVO manageVO, boolean isSave) {
        Integer type = manageVO.getType() == null ? -1 : manageVO.getType();
        List flowVOList = manageVO.getFlowVOList();
        List materialList = flowVOList.stream().map(WarehouseFlowVO::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WarehouseSurplusEntity::getProjectId, (Object)manageVO.getProjectId());
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)manageVO.getStoreId());
        queryWrapper.in(WarehouseSurplusEntity::getMaterialId, materialList);
        List surplusEntities = this.list((Wrapper)queryWrapper);
        Map<Object, Object> surplusMap = null;
        surplusMap = CollectionUtils.isNotEmpty((Collection)surplusEntities) ? surplusEntities.stream().collect(Collectors.toMap(WarehouseSurplusEntity::getMaterialId, Function.identity(), (key1, key2) -> key2)) : new HashMap();
        for (WarehouseFlowVO warehouseFlowVO : flowVOList) {
            CommonResponse commonResponse;
            WarehouseSurplusEntity surplusEntity = null;
            if (surplusMap.containsKey(warehouseFlowVO.getMaterialId())) {
                surplusEntity = (WarehouseSurplusEntity)((Object)surplusMap.get(warehouseFlowVO.getMaterialId()));
            } else {
                surplusEntity = (WarehouseSurplusEntity)((Object)BeanMapper.map((Object)warehouseFlowVO, WarehouseSurplusEntity.class));
                surplusEntity.setAttachIds(null);
                surplusEntity.setId(IdWorker.getId());
                commonResponse = this.materialApi.queryCategoryById(surplusEntity.getMaterialCategoryId());
                if (commonResponse.isSuccess() && null != commonResponse.getData()) {
                    surplusEntity.setMaterialCategoryInnerCode(((MaterialCategoryVO)commonResponse.getData()).getInnerCode());
                }
            }
            if (1 != type) {
                surplusEntity.setInstoreMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreMny(), (BigDecimal)warehouseFlowVO.getMny()));
                surplusEntity.setInstoreTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreTaxMny(), (BigDecimal)warehouseFlowVO.getTaxMny()));
            }
            if (2 != type) {
                surplusEntity.setInstoreNum(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)warehouseFlowVO.getNum()));
            }
            surplusEntity.setSurplusMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreMny(), (BigDecimal)surplusEntity.getOutLockMny()));
            surplusEntity.setSurplusTaxMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreTaxMny(), (BigDecimal)surplusEntity.getOutLockTaxMny()));
            surplusEntity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum()));
            if (ComputeUtil.isLessThan((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum())) {
                throw new BusinessException("\u7269\u8d44\u3010" + warehouseFlowVO.getMaterialName() + "\u3011\u5df2\u51fa\u5e93\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
            }
            surplusEntity.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            surplusEntity.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusTaxMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            surplusMap.put(warehouseFlowVO.getMaterialId(), (Object)surplusEntity);
            switch (warehouseFlowVO.getInOutType()) {
                case 1: {
                    this.dealFirstAttachment(isSave, type, warehouseFlowVO, surplusEntity);
                    break;
                }
                case 2: {
                    this.dealCheckAttachment(isSave, type, warehouseFlowVO, surplusEntity);
                    break;
                }
            }
            commonResponse = this.attachmentApi.queryListBySourceId(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", null);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                List fileIdList = ((List)commonResponse.getData()).stream().map(AttachmentVO::getId).collect(Collectors.toList());
                surplusEntity.setFileIds(StringUtils.join(fileIdList, (String)","));
                continue;
            }
            surplusEntity.setFileIds(null);
        }
        if (!surplusMap.isEmpty()) {
            this.saveOrUpdateBatch(surplusMap.values());
            this.updateWarehouseMny(manageVO);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u5e93\u5b58\u4f59\u91cf\u6210\u529f");
    }

    private void dealFirstAttachment(Boolean isSave, Integer type, WarehouseFlowVO warehouseFlowVO, WarehouseSurplusEntity surplusEntity) {
        if (isSave.booleanValue()) {
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(warehouseFlowVO.getSourceDetailId()), "EJCBT202208000016", "imgUpload", String.valueOf(surplusEntity.getId()), "EJCBT202208000017", "imgUpload");
        } else {
            CommonResponse commonResponse = this.attachmentApi.queryListBySourceId(warehouseFlowVO.getSourceDetailId(), "BT210816000000002", "imgUpload", null);
            if (commonResponse.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
                List fileList = ((List)commonResponse.getData()).stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
                this.attachmentApi.deleteFileByParams(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", fileList);
            }
        }
    }

    private void dealCheckAttachment(Boolean isSave, Integer type, WarehouseFlowVO warehouseFlowVO, WarehouseSurplusEntity surplusEntity) {
        CommonResponse commonResponse;
        if (isSave.booleanValue()) {
            CommonResponse commonResponse2;
            if (2 == type && (commonResponse2 = this.attachmentApi.queryListBySourceId(warehouseFlowVO.getSourceDetailId(), "BT210816000000002", "imgUpload", null)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse2.getData()))) {
                List fileList = ((List)commonResponse2.getData()).stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
                this.attachmentApi.deleteFileByParams(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", fileList);
            }
            this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(warehouseFlowVO.getSourceDetailId()), "BT210816000000002", "imgUpload", String.valueOf(surplusEntity.getId()), "EJCBT202208000017", "imgUpload");
        } else if (1 == type && (commonResponse = this.attachmentApi.queryListBySourceId(warehouseFlowVO.getSourceDetailId(), "BT210816000000002", "imgUpload", null)).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)commonResponse.getData()))) {
            List fileList = ((List)commonResponse.getData()).stream().map(AttachmentVO::getFileName).collect(Collectors.toList());
            this.attachmentApi.deleteFileByParams(surplusEntity.getId(), "EJCBT202208000017", "imgUpload", fileList);
        }
    }

    @Override
    public CommonResponse<String> updateStoreSurplusOut(WarehouseManageVO manageVO) {
        List flowVOList = manageVO.getFlowVOList();
        List materialList = flowVOList.stream().map(WarehouseFlowVO::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(WarehouseSurplusEntity::getProjectId, (Object)manageVO.getProjectId());
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)manageVO.getStoreId());
        queryWrapper.in(WarehouseSurplusEntity::getMaterialId, materialList);
        List surplusEntities = this.list((Wrapper)queryWrapper);
        Map<Object, Object> surplusMap = null;
        surplusMap = CollectionUtils.isNotEmpty((Collection)surplusEntities) ? surplusEntities.stream().collect(Collectors.toMap(WarehouseSurplusEntity::getMaterialId, Function.identity(), (key1, key2) -> key2)) : new HashMap();
        for (WarehouseFlowVO warehouseFlowVO : flowVOList) {
            WarehouseSurplusEntity surplusEntity = null;
            if (!surplusMap.containsKey(warehouseFlowVO.getMaterialId())) {
                throw new BusinessException("\u7269\u8d44\u3010" + warehouseFlowVO.getMaterialName() + "\u3011\u6ca1\u6709\u5165\u5e93!");
            }
            surplusEntity = (WarehouseSurplusEntity)((Object)surplusMap.get(warehouseFlowVO.getMaterialId()));
            surplusEntity.setOutLockMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockMny(), (BigDecimal)warehouseFlowVO.getMny()));
            surplusEntity.setOutLockTaxMny(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockTaxMny(), (BigDecimal)warehouseFlowVO.getTaxMny()));
            surplusEntity.setOutLockNum(ComputeUtil.safeAdd((BigDecimal)surplusEntity.getOutLockNum(), (BigDecimal)warehouseFlowVO.getNum()));
            if (ComputeUtil.isLessThan((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum())) {
                throw new BusinessException("\u7269\u8d44\u3010" + warehouseFlowVO.getMaterialName() + "\u3011\u5e93\u5b58\u4e0d\u8db3!");
            }
            surplusEntity.setSurplusMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreMny(), (BigDecimal)surplusEntity.getOutLockMny()));
            surplusEntity.setSurplusTaxMny(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreTaxMny(), (BigDecimal)surplusEntity.getOutLockTaxMny()));
            surplusEntity.setSurplusNum(ComputeUtil.safeSub((BigDecimal)surplusEntity.getInstoreNum(), (BigDecimal)surplusEntity.getOutLockNum()));
            surplusEntity.setSurplusPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            surplusEntity.setSurplusTaxPrice(ComputeUtil.safeDiv((BigDecimal)surplusEntity.getSurplusTaxMny(), (BigDecimal)surplusEntity.getSurplusNum()));
            surplusMap.put(warehouseFlowVO.getMaterialId(), (Object)surplusEntity);
        }
        if (!surplusMap.isEmpty()) {
            this.saveOrUpdateBatch(surplusMap.values());
            this.updateWarehouseMny(manageVO);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u5e93\u5b58\u4f59\u91cf\u6210\u529f");
    }

    private void updateWarehouseMny(WarehouseManageVO manageVO) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.select(new String[]{"sum(surplus_tax_mny) as surplusTaxMny"});
        wrapper.eq((Object)"store_id", (Object)manageVO.getStoreId());
        WarehouseSurplusEntity sumEntity = (WarehouseSurplusEntity)((Object)this.getOne((Wrapper)wrapper, false));
        if (null != sumEntity) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.set(WarehouseEntity::getTotalMny, (Object)sumEntity.getSurplusTaxMny());
            updateWrapper.eq(BaseEntity::getId, (Object)manageVO.getStoreId());
            this.warehouseService.update((Wrapper)updateWrapper);
        }
    }
}

