package com.ejianc.business.storecloud.bean;

import java.math.*;
import java.util.List;
import java.util.ArrayList;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 分包人员领料出库
 *
 * @author generator
 *
 */
 @TableName("ejc_storecloud_apply")
public class ApplyEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="supply_id")
    private String supplyId; // 分包单位主键
    @TableField(value="supply_name")
    private String supplyName; // 分包单位名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="apply_for_date")
    private String applyForDate; // 申请日期
    @TableField(value="out_date")
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private String outDate; // 出库日期
    @TableField(value="contract_id")
    private String contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="picking_id")
    private Long pickingId; // 分包领料人id
    @TableField(value="picking_name")
    private String pickingName; // 分包领料人
    @TableField(value="delivery_id")
    private Long deliveryId; // 出库人id
    @TableField(value="delivery_name")
    private String deliveryName; // 出库人
    @TableField(value="is_flag")
    private Integer isFlag; // 是否出库0否 1是 2 已失效
    @TableField(value="org_id")
    private Long orgId; //
    @TableField(value="org_name")
    private String orgName; //
    @TableField(value="cose_flag")
    private Integer coseFlag; // 3-领料出库4-直接出库
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="delivery_date")
    private String deliveryDate; // 领料日期
    @TableField(value="delivery_mny")
    private BigDecimal deliveryMny; // 出库金额
    @TableField(value="delivery_tax_mny")
    private BigDecimal deliveryTaxMny; //
    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="real_corp_id")
    private Long realCorpId; // 项目实际所属公司PK
    @TableField(value="real_corp_name")
    private String realCorpName; // 项目实际所属公司名称
    @TableField(value="qrcode")
    private String qrcode; // 二维码信息

    @TableField(exist=false)
    @SubEntity(serviceName="applyDetailService",pidName = "applyId")
    private List<ApplyDetailEntity> applyDetailEntityList = new ArrayList<>();


    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public String getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(String supplyId) {
        this.supplyId = supplyId;
    }
    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }
    public String getApplyForDate() {
        return applyForDate;
    }

    public void setApplyForDate(String applyForDate) {
        this.applyForDate = applyForDate;
    }
    public String getOutDate() {
        return outDate;
    }

    public void setOutDate(String outDate) {
        this.outDate = outDate;
    }
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getPickingId() {
        return pickingId;
    }

    public void setPickingId(Long pickingId) {
        this.pickingId = pickingId;
    }
    public String getPickingName() {
        return pickingName;
    }

    public void setPickingName(String pickingName) {
        this.pickingName = pickingName;
    }
    public Long getDeliveryId() {
        return deliveryId;
    }

    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }
    public String getDeliveryName() {
        return deliveryName;
    }

    public void setDeliveryName(String deliveryName) {
        this.deliveryName = deliveryName;
    }
    public Integer getIsFlag() {
        return isFlag;
    }

    public void setIsFlag(Integer isFlag) {
        this.isFlag = isFlag;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getCoseFlag() {
        return coseFlag;
    }

    public void setCoseFlag(Integer coseFlag) {
        this.coseFlag = coseFlag;
    }
    public String getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(String deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    public BigDecimal getDeliveryMny() {
        return deliveryMny;
    }

    public void setDeliveryMny(BigDecimal deliveryMny) {
        this.deliveryMny = deliveryMny;
    }
    public BigDecimal getDeliveryTaxMny() {
        return deliveryTaxMny;
    }

    public void setDeliveryTaxMny(BigDecimal deliveryTaxMny) {
        this.deliveryTaxMny = deliveryTaxMny;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public List<ApplyDetailEntity> getApplyDetailEntityList() {
        return applyDetailEntityList;
    }

    public void setApplyDetailEntityList(List<ApplyDetailEntity> applyDetailEntityList) {
        this.applyDetailEntityList = applyDetailEntityList;
    }

    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }

    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }

    public String getQrcode() {
        return qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }
}
