package com.ejianc.business.storecloud.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.storecloud.bean.ConfigProjectEntity;
import com.ejianc.business.storecloud.service.IConfigProjectService;
import com.ejianc.business.storecloud.vo.ConfigProjectVO;
/**
 * 设置表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("configProject")
public class ConfigProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IConfigProjectService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<ConfigProjectVO> saveOrUpdate(@RequestBody ConfigProjectVO saveOrUpdateVO) {
        ConfigProjectEntity entity = BeanMapper.map(saveOrUpdateVO, ConfigProjectEntity.class);
        //如果已经进入过，则不新增
        LambdaQueryWrapper<ConfigProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(ConfigProjectEntity::getOrgId,entity.getOrgId());
        List<ConfigProjectEntity> configProjectEntityList = service.list(queryWrapper);
        ConfigProjectVO vo = new ConfigProjectVO();

        if (CollectionUtils.isEmpty(configProjectEntityList)){
            CommonResponse<OrgVO> response = iOrgApi.detailById(entity.getOrgId());
            if (response.isSuccess() && null != response.getData()) {
                OrgVO orgVO = response.getData();
                entity.setParentId(orgVO.getParentId());
                entity.setSourceId(orgVO.getSourceId());
                CommonResponse<OrgVO> parOrgVORes = iOrgApi.detailById(orgVO.getParentId());
                if (parOrgVORes.isSuccess() && null != parOrgVORes.getData()) {
                    OrgVO parOrgVO = parOrgVORes.getData();
                    entity.setParentCode(parOrgVO.getCode());
                    entity.setParentName(parOrgVO.getName());
                    entity.setParentInnerCode(parOrgVO.getInnerCode());
                }
            }

            service.saveOrUpdate(entity, false);
            vo = BeanMapper.map(entity, ConfigProjectVO.class);
        }

    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigProjectVO> queryDetail(Long id) {
    	ConfigProjectEntity entity = service.selectById(id);
    	ConfigProjectVO vo = BeanMapper.map(entity, ConfigProjectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description修改启用状态
     * @param enabled
     */
    @RequestMapping(value = "/updateEnabled", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<Boolean> updateEnabled(@RequestParam Integer enabled) {
        //同步成功修改配置表，已经同步
        LambdaUpdateWrapper<ConfigProjectEntity> updateWrapper=new LambdaUpdateWrapper<ConfigProjectEntity>();
        updateWrapper.set(ConfigProjectEntity::getEnabled,enabled);
        updateWrapper.eq(ConfigProjectEntity::getOrgId,InvocationInfoProxy.getOrgId());
        boolean flag = service.update(updateWrapper);
        if(!flag){
            throw new BusinessException("设置状态更新失败！");
        }
        return CommonResponse.success("设置状态更新成功！",flag);
    }

    /**
     * @Description queryDetail 查询该组织是否初始化
     * @param
     */
    @RequestMapping(value = "/queryInitializeEnabled", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigProjectEntity> queryInitializeEnabled() {
        return CommonResponse.success("查询详情数据成功！",service.queryConfig(InvocationInfoProxy.getOrgId()));
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConfigProjectVO> vos) {
        service.removeByIds(vos.stream().map(ConfigProjectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<ConfigProjectVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<ConfigProjectEntity> page = service.queryPage(param,false);
        IPage<ConfigProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConfigProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<ConfigProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("ConfigProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refConfigProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<ConfigProjectVO>> refConfigProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<ConfigProjectEntity> page = service.queryPage(param,false);
        IPage<ConfigProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), ConfigProjectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
