package com.ejianc.business.storecloud.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.auth.session.SessionManager;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.vo.WarehouseVO;

/**
 * 仓库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("warehouse")
public class WarehouseController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWarehouseService warehouseService;
    @Autowired
    private IWarehouseSurplusService surplusService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WarehouseVO> saveOrUpdate(@RequestBody WarehouseVO saveOrUpdateVO) {
    	WarehouseVO vo = warehouseService.saveWarehouse(saveOrUpdateVO);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WarehouseVO> queryDetail(Long id) {
    	WarehouseEntity entity = warehouseService.selectById(id);
    	WarehouseVO vo = BeanMapper.map(entity, WarehouseVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WarehouseVO> vos) {
        List<Long> longs = vos.stream().map(WarehouseVO::getId).collect(Collectors.toList());
        for(Long key : longs){
            WarehouseEntity warehouseEntity = warehouseService.selectById(key);
            if(BooleanUtils.isTrue(warehouseEntity.getDefaultFlag())){
                throw new BusinessException("仓库【" + warehouseEntity.getWarehouseName() + "】是项目默认仓库，不允许删除！");
            }
            LambdaQueryWrapper<WarehouseSurplusEntity> queryWrapper = new LambdaQueryWrapper<>();
            queryWrapper.eq(WarehouseSurplusEntity::getStoreId, key);
            if(CollectionUtils.isNotEmpty(surplusService.list(queryWrapper))){
                throw new BusinessException("仓库【" + warehouseEntity.getWarehouseName() + "】有库存物资，不允许删除！");
            }
        }
        warehouseService.removeByIds(longs,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WarehouseVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("warehouseName");
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        IPage<WarehouseEntity> page = warehouseService.queryPage(param,false);
        IPage<WarehouseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WarehouseVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("warehouseName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        boolean mobile = param.getParams().containsKey("projectId");
        if(!mobile){
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        }
        List<WarehouseEntity> list = warehouseService.queryList(param);
        List<Map> resultMapList =  null;
        if(CollectionUtils.isNotEmpty(list)){
            resultMapList = BeanMapper.mapList(list, Map.class);
            resultMapList.forEach(vo -> {
                if (BooleanUtils.isTrue((Boolean) vo.get("state"))) {
                    vo.put("stateName", "启用");
                } else {
                    vo.put("stateName", "停用");
                }
                if (BooleanUtils.isTrue((Boolean) vo.get("defaultFlag"))) {
                    vo.put("defaultFlagName", "是");
                } else {
                    vo.put("defaultFlagName", "否");
                }
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String createTime =  sdf.format(vo.get("createTime"));
                vo.put("createTimeStr", createTime);
            });

        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", resultMapList);
        ExcelExport.getInstance().export("Warehouse-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refWarehouseData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WarehouseVO>> refWarehouseData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("warehouseName");
        fuzzyFields.add("billCode");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("state", new Parameter(QueryParam.EQ, 1));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject conjson = JSONObject.parseObject(condition);
            if(null != conjson.get("projectId")){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, conjson.get("projectId")));
            }
        }

        IPage<WarehouseEntity> page = warehouseService.queryPage(param,false);
        IPage<WarehouseVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WarehouseVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description updateState 更新启用停用
     * @param id
     */
    @RequestMapping(value = "/updateState", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> updateState(Long id, Boolean state) {
        WarehouseEntity entity = warehouseService.selectById(id);
        entity.setState(state);
        warehouseService.saveOrUpdate(entity);
        return CommonResponse.success("更新启用停用成功!");
    }
    @RequestMapping(value = "/createQRCode", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WarehouseVO> createQRCode(Long id) {
        WarehouseVO vo = warehouseService.createQRCode(id);
        return CommonResponse.success("生成二维码成功！",vo);
    }

    @RequestMapping(value = "/queryStoreByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WarehouseVO> queryStoreByProjectId(Long projectId) {
        LambdaQueryWrapper<WarehouseEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(WarehouseEntity::getProjectId, projectId);
        wrapper.eq(WarehouseEntity::getDefaultFlag, 1);
        wrapper.eq(WarehouseEntity::getState, 1);
        WarehouseEntity entity = warehouseService.getOne(wrapper, false);
        return CommonResponse.success("获取默认仓库成功！", null != entity ? BeanMapper.map(entity, WarehouseVO.class) : null);
    }

}
