package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseSurplusVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 仓库存量表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("warehouseSurplus")
public class WarehouseSurplusController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IWarehouseSurplusService surplusService;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IAttachmentApi attachmentApi;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WarehouseSurplusVO> saveOrUpdate(@RequestBody WarehouseSurplusVO saveOrUpdateVO) {
    	WarehouseSurplusEntity entity = BeanMapper.map(saveOrUpdateVO, WarehouseSurplusEntity.class);
        surplusService.saveOrUpdate(entity, false);
    	WarehouseSurplusVO vo = BeanMapper.map(entity, WarehouseSurplusVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WarehouseSurplusVO> queryDetail(Long id) {
    	WarehouseSurplusEntity entity = surplusService.selectById(id);
    	WarehouseSurplusVO vo = BeanMapper.map(entity, WarehouseSurplusVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WarehouseSurplusVO> vos) {
        List<Long> longList = vos.stream().map(WarehouseSurplusVO::getId).collect(Collectors.toList());
       /* List<WarehouseSurplusEntity> surplusEntities = (List<WarehouseSurplusEntity>) surplusService.listByIds(longList);
        for(WarehouseSurplusEntity surplusEntity : surplusEntities ){
            if(ComputeUtil.isGreaterThan(surplusEntity.getOutLockNum(), BigDecimal.ZERO)){
                throw new BusinessException("物资【" + surplusEntity.getMaterialName() + "】已发生出库，不允许删除!");
            }
        }*/
        surplusService.removeByIds(longList,true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WarehouseSurplusVO>> queryList(@RequestBody QueryParam param) {
      /*  if(null == param.getParams().get("storeId")){
            return  CommonResponse.error("仓库主键为空！");
        }*/
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("categoryId")){
            param.getParams().put("materialCategoryInnerCode", new Parameter(QueryParam.LIKE, param.getParams().get("categoryId").getValue()));
            param.getParams().remove("categoryId");
        }
        param.getParams().put("surplusNum", new Parameter(QueryParam.GT, 0));//库存数量大于0
        IPage<WarehouseSurplusEntity> page = surplusService.queryPage(param,false);
        IPage<WarehouseSurplusVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WarehouseSurplusVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refSurplusData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WarehouseSurplusVO>> refSurplusData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                    String condition,
                                                                    String searchObject,
                                                                    String searchText) {
        QueryParam param = new QueryParam();
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("surplusNum", new Parameter(QueryParam.GT, 0));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject conjson = JSONObject.parseObject(condition);
            if(null != conjson.get("storeId")){
                param.getParams().put("storeId", new Parameter(QueryParam.EQ, conjson.get("storeId")));
            }
        }

        IPage<WarehouseSurplusEntity> page = surplusService.queryPage(param,false);
        IPage<WarehouseSurplusVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<WarehouseSurplusVO> warehouseSurplusVOS = BeanMapper.mapList(page.getRecords(), WarehouseSurplusVO.class);
        for(WarehouseSurplusVO surplusVO : warehouseSurplusVOS){
            if(StringUtils.isNotEmpty(surplusVO.getFileIds())){
                CommonResponse<AttachmentVO> response = attachmentApi.queryDetail(surplusVO.getFileIds().split(",")[0]);
                if (response.isSuccess() && null != response.getData()) {
                    surplusVO.setMainUrl(response.getData().getFilePath());
                }
            }
        }
        pageData.setRecords(warehouseSurplusVOS);
        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    @RequestMapping(value = "/lazyMaterialCategory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(@RequestParam(value = "parentId", required = false) Long parentId, @RequestParam(value = "storeId")  Long storeId) {
        LambdaQueryWrapper<WarehouseSurplusEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.eq(WarehouseSurplusEntity::getStoreId, storeId);
        queryWrapper.like(null != parentId, WarehouseSurplusEntity::getMaterialCategoryInnerCode, parentId);
        List<WarehouseSurplusEntity> surplusEntities = surplusService.list(queryWrapper);
        List<MaterialCategoryVO> materialCategoryVO = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(surplusEntities)){
            List<Long> categoryIdList = surplusEntities.stream().map(WarehouseSurplusEntity::getMaterialCategoryId).collect(Collectors.toList());
            CommonResponse<List<MaterialCategoryVO>> materialCategoryVOS = materialApi.queryCategoryListByChildren(categoryIdList);
            List<MaterialCategoryVO> dateList = materialCategoryVOS.getData();
            if (parentId != null){ // 选择树形查找子集
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() !=null && materialCategoryVO1.getParentId().equals(parentId)){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }else { // 刷新页面查询全部树形
                for (MaterialCategoryVO materialCategoryVO1 : dateList){
                    if (materialCategoryVO1.getParentId() ==null ){
                        materialCategoryVO.add(materialCategoryVO1);
                    }
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }
}
