package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.PersionProjectEntity;
import com.ejianc.business.storecloud.enums.WechatErrorEnum;
import com.ejianc.business.storecloud.service.impl.PersionProjectServiceImpl;
import com.ejianc.business.storecloud.utils.MD5Utils;
import com.ejianc.business.storecloud.utils.WeChatUtil;
import com.ejianc.business.storecloud.vo.PersionProjectVO;
import com.ejianc.foundation.usercenter.api.IThirdSystemApi;
import com.ejianc.foundation.usercenter.vo.ThirdSystemVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("wechat")
public class WechatController implements Serializable {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private WeChatUtil weChatUtil;

    @Autowired
    private IThirdSystemApi thirdSystemApi;

    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private PersionProjectServiceImpl persionProjectService;


    /**
     * @Description openId 获取openid
     * @param code
     */
    @RequestMapping(value = "/openId", method = RequestMethod.GET)
    @ResponseBody
    public Map openId(@RequestParam("code") String code) {
        return weChatUtil.oauth2GetOpenid(code);
    }

    /**
     * @Description anaLogin 模拟登录
     * @param request
     */
    @RequestMapping(value = "no_auth/anaLogin", method = RequestMethod.POST)
    @ResponseBody
    private Map anaLogin(@RequestBody PersionProjectVO persionVO, HttpServletRequest request) {
        Map<String, String> map = weChatUtil.oauth2GetOpenid(persionVO.getWechatCode());
        CommonResponse<ThirdSystemVO> thirdSystemVO = thirdSystemApi.getOneByCode("ZJWJ");
        logger.info("thirdSystemVO " + JSONObject.toJSONString(thirdSystemVO.getData()));
        try {
            if (thirdSystemVO.isSuccess() && thirdSystemVO.getData() != null) {
                Map<String, Object> params = new HashMap<>();
                params.put("tenantId", thirdSystemVO.getData().getTenantId());
                logger.info("baseHost " + baseHost);
                String back = HttpTookit.get(baseHost + "ejc-idm-web/user/context/getBytenantid", params, request);
                String authority = "";
                JSONObject jsonBack = JSONObject.parseObject(back);
                if (jsonBack.get("data") != null) {
                    JSONObject data = (JSONObject) jsonBack.get("data");
                    logger.info("data  " + data.toJSONString());
                    if (data.get("userContext") != null) {
                        JSONObject userContext = (JSONObject) data.get("userContext");
                        authority = "userType=" + userContext.getString("userType") + ";userCode="
                                + userContext.getString("userCode") +
                                // ";userName="+userContext.getString("userName")
                                // +
                                ";orgId=" + userContext.getString("orgId") +
                                // ";orgName="+userContext.getString("orgName")
                                // +
                                ";tenantid=" + userContext.getString("tenantid") + ";token="
                                + userContext.getString("token") + ";u_logints=" + userContext.getString("u_logints")
                                + ";u_usercode=" + userContext.getString("u_usercode") + ";userId="
                                + userContext.getString("userId");
                        map.put("authority", authority);
                    }
                }
            } else {
                throw new BusinessException("根据系统code：ZJWJ获取第三方系统信息失败");
            }
        } catch (Exception e) {
            logger.info(e.getMessage());
        }
        return map;
    }

    /**
     * @param request
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/wechatlogin", method = RequestMethod.POST)
    @ResponseBody
    private CommonResponse<PersionProjectVO> wechatlogin(@RequestBody PersionProjectVO persionVO, HttpServletRequest request) {
        logger.info("wechatlogin : openid" + persionVO.getOpenId());
        if (StringUtils.isBlank(persionVO.getOpenId())) {
            throw new BusinessException("系统异常,未获取openid！");
        }
        LambdaQueryWrapper<PersionProjectEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PersionProjectEntity::getOpenId, persionVO.getOpenId());
        wrapper.eq(PersionProjectEntity::getBindStatus, 1);
        PersionProjectEntity persionProjectEntity = persionProjectService.getOne(wrapper);
        if (null == persionProjectEntity) {
            return CommonResponse.error(WechatErrorEnum.OPENID未绑定.getCode(), "OPENID未绑定");
        }
        if(persionProjectEntity.getFirstFlag()){
            return CommonResponse.error(WechatErrorEnum.初次登录.getCode(), "初次登录，请修改密码");
        }
        PersionProjectVO persionProjectVO = BeanMapper.map(persionProjectEntity, PersionProjectVO.class);
        return CommonResponse.success("登录成功", persionProjectVO);
    }

    @RequestMapping(value = "/bindWechat", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PersionProjectVO> bindWechat(@RequestBody PersionProjectVO persionProjectVO, HttpServletRequest request) {
        if (StringUtils.isBlank(persionProjectVO.getOpenId())) {
            throw new BusinessException("系统异常,未获取openid！");
        }
        LambdaQueryWrapper<PersionProjectEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(PersionProjectEntity::getUserName, persionProjectVO.getUserName());
        PersionProjectEntity persionProjectEntity = persionProjectService.getOne(wrapper);
        if(null == persionProjectEntity){
            return CommonResponse.error(WechatErrorEnum.账号不存在.getCode(), "账号不存在");
        }
        if(!persionProjectEntity.getUserPwd().equals(MD5Utils.getStringMD5(persionProjectVO.getUserPwd()))){
            return CommonResponse.error(WechatErrorEnum.密码错误.getCode(), "密码错误");
        }
        if(0 == persionProjectEntity.getEnabled()){
            return CommonResponse.error(WechatErrorEnum.该用户已停用.getCode(), "该用户已停用");
        }
        persionProjectEntity.setBindStatus(1);
        persionProjectEntity.setOpenId(persionProjectVO.getOpenId());
        persionProjectService.updateById(persionProjectEntity);
        if(persionProjectEntity.getFirstFlag()){
            return CommonResponse.error(WechatErrorEnum.初次登录.getCode(), "初次登录，请修改密码");
        }
        persionProjectVO = BeanMapper.map(persionProjectEntity, PersionProjectVO.class);
        return CommonResponse.success("绑定成功", persionProjectVO);
    }
}
