/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.ApplyEntity;
import com.ejianc.business.storecloud.bean.PersionProjectEntity;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.enums.InOutTypeEnum;
import com.ejianc.business.storecloud.enums.OutStatusEnum;
import com.ejianc.business.storecloud.mapper.ApplyMapper;
import com.ejianc.business.storecloud.service.IApplyService;
import com.ejianc.business.storecloud.service.IPersionProjectService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.utils.WeChatUtil;
import com.ejianc.business.storecloud.vo.ApplyVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.util.QRCodeUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="applyService")
public class ApplyServiceImpl
extends BaseServiceImpl<ApplyMapper, ApplyEntity>
implements IApplyService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_CODE = "FBLL_LLCK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IWarehouseService warehouseService;
    @Autowired
    private IPersionProjectService persionProjectService;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Value(value="${common.env.base-host}")
    private String baseHost;

    @Override
    public ApplyVO saveApply(ApplyVO saveOrUpdateVO) {
        ApplyEntity entity = (ApplyEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ApplyEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        entity.setIsFlag(OutStatusEnum.\u5f85\u51fa\u5e93.getCode());
        entity.setOrgId(InvocationInfoProxy.getOrgId());
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        CommonResponse orgVO = this.iOrgApi.detailById(InvocationInfoProxy.getOrgId());
        entity.setOrgName(((OrgVO)orgVO.getData()).getName());
        this.saveOrUpdate((Object)entity, false);
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)entity), ApplyVO.class));
    }

    @Override
    public ApplyVO addForScan(Long storeId, String openId) {
        ApplyVO applyVO = new ApplyVO();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getId, (Object)storeId);
        WarehouseEntity warehouseEntity = (WarehouseEntity)((Object)this.warehouseService.getOne((Wrapper)queryWrapper, false));
        applyVO.setOrgId(warehouseEntity.getOrgId());
        applyVO.setOrgName(warehouseEntity.getOrgName());
        applyVO.setProjectId(warehouseEntity.getProjectId());
        applyVO.setProjectName(warehouseEntity.getProjectName());
        applyVO.setStoreId(warehouseEntity.getId());
        applyVO.setStoreName(warehouseEntity.getWarehouseName());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(PersionProjectEntity::getOpenId, (Object)openId);
        this.logger.info("======================================storeId====================================== storeId:" + storeId);
        this.logger.info("======================================openId====================================== openId:" + openId);
        PersionProjectEntity persionProjectEntity = (PersionProjectEntity)((Object)this.persionProjectService.getOne((Wrapper)wrapper, false));
        applyVO.setSupplyId(persionProjectEntity.getSupplyId());
        applyVO.setSupplyName(persionProjectEntity.getSupplyName());
        applyVO.setContractId(persionProjectEntity.getContractId());
        applyVO.setContractCode(persionProjectEntity.getContractCode());
        applyVO.setContractName(persionProjectEntity.getContractName());
        applyVO.setPickingId(persionProjectEntity.getId());
        applyVO.setPickingName(persionProjectEntity.getName());
        return applyVO;
    }

    @Override
    public ApplyVO createQRCode(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        String path = "pick/codeCard?id=" + id;
        QRCodeUtil qrCodeUtil = new QRCodeUtil();
        String multipartFile = qrCodeUtil.getBase64QRCode(path, Integer.valueOf(430), Integer.valueOf(280), null, null, null);
        String baseAddr = null;
        if (this.baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        } else if (this.baseHost.contains("9082")) {
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        } else if (this.baseHost.contains("9080")) {
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        applyEntity.setQrcode(baseAddr + this.dealImg(multipartFile, applyEntity));
        this.saveOrUpdate((Object)applyEntity);
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class));
    }

    @Override
    public ApplyVO selectDetail(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.selectById(id));
        return (ApplyVO)((Object)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class));
    }

    @Override
    public List<ApplyEntity> selectList(List<ApplyEntity> applyEntityList) {
        for (ApplyEntity applyEntity : applyEntityList) {
            if (applyEntity.getBillState() != 2 && applyEntity.getBillState() != 4 && applyEntity.getBillState() != 5 || !OutStatusEnum.\u5f85\u51fa\u5e93.getCode().equals(applyEntity.getIsFlag()) || !InOutTypeEnum.\u9886\u6599\u51fa\u5e93.getCode().equals(applyEntity.getCoseFlag())) continue;
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                Date checkTime = sdf.parse(applyEntity.getApplyForDate());
                Date d = new Date();
                GregorianCalendar calendar = new GregorianCalendar();
                calendar.setTime(checkTime);
                ((Calendar)calendar).add(12, 120);
                if (1 != d.compareTo(calendar.getTime())) continue;
                applyEntity.setIsFlag(OutStatusEnum.\u5df2\u5931\u6548.getCode());
                this.updateById((Object)applyEntity);
            }
            catch (ParseException e) {
                this.logger.error(e.getMessage());
            }
        }
        return null;
    }

    private String dealImg(String file, ApplyEntity applyEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202208000007");
        attachmentVO.setSourceId(String.valueOf(applyEntity.getId()));
        attachmentVO.setSourceType("EJCBT202208000007");
        attachmentVO.setFileList(Arrays.asList(file));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

