/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseFlowEntity;
import com.ejianc.business.storecloud.bean.WarehouseInoutEntity;
import com.ejianc.business.storecloud.enums.InOutFlagEnum;
import com.ejianc.business.storecloud.mapper.WarehouseInoutMapper;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.service.IWarehouseInoutService;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="warehouseInoutService")
public class WarehouseInoutServiceImpl
extends BaseServiceImpl<WarehouseInoutMapper, WarehouseInoutEntity>
implements IWarehouseInoutService {
    @Autowired
    private IWarehouseFlowService warehouseFlowService;

    @Override
    public CommonResponse<String> updateInout(List<WarehouseFlowEntity> flowEntityList, boolean isSave) {
        ArrayList<WarehouseInoutEntity> inoutList = new ArrayList<WarehouseInoutEntity>();
        if (isSave) {
            block0: for (WarehouseFlowEntity outFlowEntity : flowEntityList) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(WarehouseFlowEntity::getProjectId, (Object)outFlowEntity.getProjectId());
                queryWrapper.eq(WarehouseFlowEntity::getStoreId, (Object)outFlowEntity.getStoreId());
                queryWrapper.eq(WarehouseFlowEntity::getMaterialId, (Object)outFlowEntity.getMaterialId());
                queryWrapper.eq(WarehouseFlowEntity::getInOutFlag, (Object)InOutFlagEnum.\u5165\u5e93.getCode());
                queryWrapper.orderByAsc(BaseEntity::getCreateTime);
                List inFlowEntities = this.warehouseFlowService.list((Wrapper)queryWrapper);
                if (!CollectionUtils.isNotEmpty((Collection)inFlowEntities)) continue;
                for (WarehouseFlowEntity inFlowEntity : inFlowEntities) {
                    BigDecimal sunNum;
                    QueryWrapper wrapper = new QueryWrapper();
                    wrapper.select(new String[]{"sum(num) as num"});
                    wrapper.eq((Object)"in_flow_id", (Object)inFlowEntity.getId());
                    WarehouseInoutEntity sumEntity = (WarehouseInoutEntity)((Object)this.getOne((Wrapper)wrapper));
                    BigDecimal bigDecimal = sunNum = sumEntity == null ? null : sumEntity.getNum();
                    if (!ComputeUtil.isGreaterThan((BigDecimal)inFlowEntity.getNum(), (BigDecimal)sunNum)) continue;
                    BigDecimal sub = ComputeUtil.safeSub((BigDecimal)inFlowEntity.getNum(), (BigDecimal)sunNum);
                    if (ComputeUtil.isLessOrEqual((BigDecimal)outFlowEntity.getNum(), (BigDecimal)sub)) {
                        inoutList.add(this.covertEntity(outFlowEntity, inFlowEntity));
                        continue block0;
                    }
                    WarehouseInoutEntity inoutEntity = this.covertEntity(outFlowEntity, inFlowEntity);
                    inoutEntity.setNum(sub);
                    inoutEntity.setMny(ComputeUtil.safeMultiply((BigDecimal)inoutEntity.getPrice(), (BigDecimal)sub));
                    inoutEntity.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)inoutEntity.getTaxPrice(), (BigDecimal)sub));
                    inoutList.add(inoutEntity);
                    outFlowEntity.setNum(ComputeUtil.safeSub((BigDecimal)outFlowEntity.getNum(), (BigDecimal)sub));
                    outFlowEntity.setMny(ComputeUtil.safeMultiply((BigDecimal)outFlowEntity.getPrice(), (BigDecimal)sub));
                    outFlowEntity.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)outFlowEntity.getTaxPrice(), (BigDecimal)sub));
                }
            }
            this.saveOrUpdateBatch(inoutList);
        } else {
            List srcDetailidList = flowEntityList.stream().map(WarehouseFlowEntity::getSourceDetailId).collect(Collectors.toList());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.in(WarehouseInoutEntity::getOutBillDetailId, srcDetailidList);
            this.remove((Wrapper)queryWrapper);
        }
        return CommonResponse.success((String)"\u66f4\u65b0\u4ed3\u5e93\u51fa\u5e93\u5173\u8054\u8868\u6210\u529f\uff01");
    }

    private WarehouseInoutEntity covertEntity(WarehouseFlowEntity outFlowEntity, WarehouseFlowEntity inFlowEntity) {
        WarehouseInoutEntity inoutEntity = (WarehouseInoutEntity)((Object)BeanMapper.map((Object)((Object)outFlowEntity), WarehouseInoutEntity.class));
        inoutEntity.setInFlowId(inFlowEntity.getId());
        inoutEntity.setOutFlowId(outFlowEntity.getId());
        inoutEntity.setProjectId(inFlowEntity.getProjectId());
        inoutEntity.setProjectName(inFlowEntity.getProjectName());
        inoutEntity.setStoreId(inFlowEntity.getStoreId());
        inoutEntity.setStoreName(inFlowEntity.getProjectName());
        inoutEntity.setOutDate(outFlowEntity.getBillDate());
        inoutEntity.setInOutType(outFlowEntity.getInOutType());
        inoutEntity.setInOutTypeName(outFlowEntity.getInOutTypeName());
        inoutEntity.setInBillId(inFlowEntity.getSourceId());
        inoutEntity.setInBillDetailId(inFlowEntity.getSourceDetailId());
        inoutEntity.setInBillCode(inFlowEntity.getBillCode());
        inoutEntity.setOutBillId(outFlowEntity.getSourceId());
        inoutEntity.setOutBillDetailId(outFlowEntity.getSourceDetailId());
        inoutEntity.setOutDate(outFlowEntity.getBillDate());
        return inoutEntity;
    }
}

