package com.ejianc.business.storecloud.controller.api;


import com.ejianc.business.storecloud.service.IMaterialProjectService;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import java.io.Serializable;
import java.util.List;

/**
 * 查询是否是云库存材料
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/cloudMeterial")
public class CloudMeterialApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IMaterialProjectService materialProjectService;

    /**
     * @Description push 推送
     */
    @RequestMapping(value = "/queryCloudMeterial", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<Long>> queryCloudMeterial(@RequestParam(value = "materialIds", required = false) List<Long> materialIds, @RequestParam(value = "orgId", required = false) Long orgId) {
    	return CommonResponse.success("查询数据成功！",materialProjectService.isCloudMaterials(materialIds,orgId));
    }

}
