package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.storecloud.bean.ConfigProjectEntity;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.service.IConfigProjectService;
import com.ejianc.business.storecloud.service.IMaterialOrgService;
import com.ejianc.business.storecloud.vo.MaterialProjectVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.storecloud.mapper.MaterialProjectMapper;
import com.ejianc.business.storecloud.bean.MaterialProjectEntity;
import com.ejianc.business.storecloud.service.IMaterialProjectService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * 项目领料设置-项目(材料表)
 * 
 * @author generator
 * 
 */
@Service("materialProjectService")
public class MaterialProjectServiceImpl extends BaseServiceImpl<MaterialProjectMapper, MaterialProjectEntity> implements IMaterialProjectService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IConfigProjectService configProjectService;

    @Autowired
    private IMaterialOrgService materialOrgService;

    @Autowired
    private IMaterialApi materialApi;

    @Override
    public List<MaterialProjectVO> saveOrUpdate(List<MaterialProjectVO> saveOrUpdateVO) {
        List<MaterialProjectVO> vo = new ArrayList<>();
        for (MaterialProjectVO materialProjectVO : saveOrUpdateVO){
            if (materialProjectVO.getId()!=null){
                LambdaQueryWrapper<MaterialProjectEntity> queryWrapper = new LambdaQueryWrapper<>();
                queryWrapper.eq(MaterialProjectEntity::getMaterialId,materialProjectVO.getId());
                queryWrapper.eq(MaterialProjectEntity::getOrgId,InvocationInfoProxy.getOrgId());
                queryWrapper.eq(MaterialProjectEntity::getDr,0);
                List<MaterialProjectEntity> materialProjectEntityList = super.list(queryWrapper);
                if (CollectionUtils.isNotEmpty(materialProjectEntityList)){
                    throw  new BusinessException("编号为"+materialProjectVO.getCode()+"的"+materialProjectVO.getName()+"已被引用！");
                }
            }
            materialProjectVO.setMaterialId(materialProjectVO.getId());
            materialProjectVO.setMaterialCode(materialProjectVO.getCode());
            materialProjectVO.setMaterialName(materialProjectVO.getName());
            materialProjectVO.setMaterialUnitName(materialProjectVO.getUnitName());
            materialProjectVO.setMaterialSpec(materialProjectVO.getSpec());
            materialProjectVO.setMaterialCategoryId(materialProjectVO.getCategoryId());
            materialProjectVO.setMaterialCategoryName(materialProjectVO.getCategoryName());
            materialProjectVO.setMaterialCategoryCode(materialProjectVO.getCategoryCode());
            CommonResponse<MaterialCategoryVO> materialCategoryVO = materialApi.queryCategoryById(materialProjectVO.getCategoryId());
            materialProjectVO.setMaterialCategoryInnerCode(materialCategoryVO.getData().getInnerCode());
            materialProjectVO.setOrgId(InvocationInfoProxy.getOrgId());
            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(materialProjectVO.getOrgId());
            materialProjectVO.setOrgCode(orgVo.getData().getCode());
            materialProjectVO.setOrgName(orgVo.getData().getName());
            MaterialProjectEntity entity = BeanMapper.map(materialProjectVO, MaterialProjectEntity.class);
            entity.setId(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setTenantId(null);
            super.saveOrUpdate(entity, false);
            vo.add(BeanMapper.map(entity, MaterialProjectVO.class));
        }
        return vo;
    }

    @Override
    public int synchronization() {
        //查询配置表信息
        ConfigProjectEntity configProjectEntity = configProjectService.queryConfig(InvocationInfoProxy.getOrgId());
        if(configProjectEntity == null){
            throw new BusinessException("未获取到配置信息，同步失败 ！");
        }
        String innerCode = configProjectEntity.getParentInnerCode();
        String[] strs = innerCode.split("\\|");
        List<Long> childIds = new ArrayList<>();
        for(String id:strs){
            //不添加当前组织
            if(Long.parseLong(id) != InvocationInfoProxy.getOrgId()){
                childIds.add(Long.parseLong(id));
            }
        }
        Collections.reverse(childIds);//将list倒叙排列
        List<MaterialOrgEntity> materialOrgEntityList = new ArrayList<>();
        for(Long orgId:childIds){
                if(configProjectEntity.getEnabled() == 1){//如果是启用状态才查
                    //根据orgId查询公司设置云库存材料
                    LambdaQueryWrapper<MaterialOrgEntity> queryWrapper = new LambdaQueryWrapper<MaterialOrgEntity>();
                    queryWrapper.in(MaterialOrgEntity::getOrgId,orgId);
                    List<MaterialOrgEntity> materialOrgEntities = materialOrgService.list(queryWrapper);
                    //如果查到上级有云库存材料，则添加引入
                    if (CollectionUtils.isNotEmpty(materialOrgEntities)) {
                        materialOrgEntityList.addAll(materialOrgEntities);
                    }
                }
        }
        if (CollectionUtils.isNotEmpty(materialOrgEntityList)) {
           for(MaterialOrgEntity materialOrgEntity:materialOrgEntityList){
               MaterialProjectEntity materialProjectEntity = new MaterialProjectEntity();
               materialProjectEntity.setMaterialId(materialOrgEntity.getMaterialId());
               materialProjectEntity.setMaterialCode(materialOrgEntity.getMaterialCode());
               materialProjectEntity.setMaterialName(materialOrgEntity.getMaterialName());
               materialProjectEntity.setMaterialSpec(materialOrgEntity.getSpec());
               materialProjectEntity.setMaterialUnitName(materialOrgEntity.getUnit());
               materialProjectEntity.setMaterialCategoryId(materialOrgEntity.getCategoryId());
               materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
               materialProjectEntity.setMaterialCategoryName(materialOrgEntity.getCategoryName());
               materialProjectEntity.setOrgId(InvocationInfoProxy.getOrgId());//存当前组织id
               materialProjectEntity.setMaterialCategoryInnerCode(materialOrgEntity.getCategoryInnerCode());
               CommonResponse<List<OrgVO>> parentOrgList =iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
               materialProjectEntity.setOrgCode(parentOrgList.getData().get(0).getCode());
               materialProjectEntity.setParentId(parentOrgList.getData().get(0).getParentId());
               materialProjectEntity.setOrgName(parentOrgList.getData().get(0).getName());
               if (materialOrgEntity.getMaterialId()!=null){
                   LambdaQueryWrapper<MaterialProjectEntity> queryWrappers = new LambdaQueryWrapper<>();
                   queryWrappers.eq(MaterialProjectEntity::getMaterialId,materialOrgEntity.getMaterialId());
                   queryWrappers.eq(MaterialProjectEntity::getOrgId,InvocationInfoProxy.getOrgId());
                   queryWrappers.eq(MaterialProjectEntity::getDr,0);
                   List<MaterialProjectEntity> materialProjectEntityList = super.list(queryWrappers);
                   if (CollectionUtils.isNotEmpty(materialProjectEntityList)){
                       //如果引入过了 直接跳过
                       continue;
                   }
               }
               saveOrUpdate(materialProjectEntity);
           }
        }
        //同步成功修改配置表，已经同步
        LambdaUpdateWrapper<ConfigProjectEntity> updateWrapper=new LambdaUpdateWrapper<ConfigProjectEntity>();
        updateWrapper.set(ConfigProjectEntity::getInitializeEnabled,1);
        updateWrapper.set(ConfigProjectEntity::getEnabled,1);
        updateWrapper.eq(ConfigProjectEntity::getOrgId,InvocationInfoProxy.getOrgId());
        boolean flag = configProjectService.update(updateWrapper);
        if(!flag){
            throw new BusinessException("设置状态更新失败！");
        }
        return 0;//成功
    }

    @Override
    public Boolean isCloudMaterial(Long materialId,Long orgId) {
        //查询此项目部是否开启，如果开启才查找，如果不开启直接全部否
        LambdaQueryWrapper<ConfigProjectEntity> queryWrappesr = new LambdaQueryWrapper<ConfigProjectEntity>();
        queryWrappesr.eq(ConfigProjectEntity::getOrgId,orgId);
        queryWrappesr.eq(ConfigProjectEntity::getEnabled,1);
        List<ConfigProjectEntity> configProjectEntityList = configProjectService.list(queryWrappesr);

        if(CollectionUtils.isNotEmpty(configProjectEntityList)){
            List<MaterialProjectEntity> materialProjectEntityList = new ArrayList<>();
            LambdaQueryWrapper<MaterialProjectEntity> queryWrapper = new LambdaQueryWrapper<MaterialProjectEntity>();
            queryWrapper.eq(MaterialProjectEntity::getOrgId,orgId);
            queryWrapper.eq(MaterialProjectEntity::getMaterialId,materialId);
            materialProjectEntityList = list(queryWrapper);
            //如果查到本级设置是云库存材料,直接返回true
            if(CollectionUtils.isNotEmpty(materialProjectEntityList)){
                return true;
            }else{
                //如果本级未设置，查询所有上级是否设置次材料为云库存材料
                CommonResponse<OrgVO> parOrg =iOrgApi.detailById(orgId);
                List<MaterialOrgEntity> materialOrgEntities = new ArrayList<>();
                if (parOrg.isSuccess() & null != parOrg.getData()) {
                    OrgVO parOrgVO = parOrg.getData();
                    String innerCode = parOrgVO.getInnerCode();
                    String[] strs = innerCode.split("\\|");
                    List<Long> childIds = new ArrayList<>();
                    for(String id:strs){
                        childIds.add(Long.parseLong(id));
                    }
                    LambdaQueryWrapper<MaterialOrgEntity> queryWrappers = new LambdaQueryWrapper<MaterialOrgEntity>();
                    queryWrappers.in(MaterialOrgEntity::getOrgId,childIds);
                    queryWrappers.eq(MaterialOrgEntity::getMaterialId,materialId);
                    materialOrgEntities = materialOrgService.list(queryWrappers);
                }
                if(CollectionUtils.isNotEmpty(materialOrgEntities)){
                    return true;
                }else{
                    return false;
                }
            }
        }else{
            return false;
        }
    }

    @Override
    public List<Long> isCloudMaterials(List<Long> materialIds, Long orgId) {
        //查询此项目部是否开启，如果开启才查找，如果不开启直接全部否
        LambdaQueryWrapper<ConfigProjectEntity> queryWrappesr = new LambdaQueryWrapper<ConfigProjectEntity>();
        queryWrappesr.eq(ConfigProjectEntity::getOrgId,orgId);
        queryWrappesr.eq(ConfigProjectEntity::getEnabled,1);
        List<ConfigProjectEntity> configProjectEntityList = configProjectService.list(queryWrappesr);
        //项目开启才会判断是否是云库存材料
        if(CollectionUtils.isNotEmpty(configProjectEntityList)){
            //先查询本级是否设置
            List<MaterialProjectEntity> materialProjectEntityList = new ArrayList<>();
            List<Long> cloudMaterialsVOList = new ArrayList<>();//是云库房材料的物料主键
            List<Long> materialIdList = new ArrayList<>();//在本级已经查到是云库房材料的物料主键
            for(Long materialId : materialIds){
                //查询本级是否是云库房材料
                LambdaQueryWrapper<MaterialProjectEntity> queryWrappers = new LambdaQueryWrapper<MaterialProjectEntity>();
                queryWrappers.eq(MaterialProjectEntity::getOrgId,orgId);
                queryWrappers.eq(MaterialProjectEntity::getMaterialId,materialId);
                List<MaterialProjectEntity> materialProjectEntities = list(queryWrappers);
                if(CollectionUtils.isNotEmpty(materialProjectEntities)){
                    materialProjectEntityList.addAll(materialProjectEntities);
                    //如果查到了就添加到是云库房材料id集合
                    materialIdList.add(materialId);
                }
            }
            if(CollectionUtils.isNotEmpty(materialProjectEntityList)){
                for(MaterialProjectEntity materialProjectEntity : materialProjectEntityList){
                    cloudMaterialsVOList.add(materialProjectEntity.getMaterialId());
                }
            }
            //查询上级时候设置此材料为云库房材料
            List<Long> childIds = new ArrayList<>();
            CommonResponse<OrgVO> parOrg =iOrgApi.detailById(orgId);
            if (parOrg.isSuccess() & null != parOrg.getData()) {
                OrgVO parOrgVO = parOrg.getData();
                String innerCode = parOrgVO.getInnerCode();
                String[] strs = innerCode.split("\\|");
                for (String id : strs) {
                    childIds.add(Long.parseLong(id));
                }
                Collections.reverse(childIds);//将list倒叙排列
            }

            List<MaterialOrgEntity> materialOrgEntityList = new ArrayList<>();
            for(Long materialId : materialIds){
                if(!materialIdList.contains(materialId)){//如果查到的id不包含证明未查到，就找上级看是否设置
                    for(Long orgIdc:childIds){
                        LambdaQueryWrapper<MaterialOrgEntity> queryWrappers = new LambdaQueryWrapper<MaterialOrgEntity>();
                        queryWrappers.eq(MaterialOrgEntity::getOrgId,orgIdc);
                        queryWrappers.eq(MaterialOrgEntity::getMaterialId,materialId);
                        List<MaterialOrgEntity> materialOrgEntities = materialOrgService.list(queryWrappers);
                        if(CollectionUtils.isNotEmpty(materialOrgEntities)){
                            materialOrgEntityList.addAll(materialOrgEntities);
                            break;//不在找上级
                        }
                    }
                }
            }

            if(CollectionUtils.isNotEmpty(materialOrgEntityList)){
                for(MaterialOrgEntity materialOrgEntity:materialOrgEntityList){
                    cloudMaterialsVOList.add(materialOrgEntity.getMaterialId());
                }
            }
            return cloudMaterialsVOList;
        }else{
            return null;
        }

    }
}
