package com.ejianc.business.storecloud.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 内部人员领料出库
 *
 * @author generator
 *
 */
 @TableName("ejc_storecloud_out")
public class OutEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="project_id")
    private Long projectId; // 项目ID
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="store_id")
    private Long storeId; // 仓库
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="supply_id")
    private String supplyId; // 分包单位主键
    @TableField(value="supply_name")
    private String supplyName; // 分包单位名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="apply_for_date")
    private String applyForDate; // 申请日期
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value="out_date")
    private String outDate; // 出库日期
    @TableField(value="contract_id")
    private String contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="picking_id")
    private Long pickingId; // 分包领料人id
    @TableField(value="picking_name")
    private String pickingName; // 分包领料人
    @TableField(value="out_persion_id")
    private Long outPersionId; // 出库人id
    @TableField(value="out_persion_name")
    private String outPersionName; // 出库人
    @TableField(value="org_id")
    private Long orgId; // 组织主键
    @TableField(value="org_name")
    private String orgName; // 组织名称
    @TableField(value="org_code")
    private String orgCode; // 组织编码
    @TableField(value="cose_flag")
    private Integer coseFlag; // 3-领料出库4-直接出库
    @TableField(value="out_mny")
    private BigDecimal outMny;//出库金额
    @TableField(value="out_tax_mny")
    private BigDecimal outTaxMny; // 出库金额
    @TableField(value="bill_state")
    private Integer billState;
    @TableField(value="bill_code")
    private String billCode; // 组织名称
    @TableField(value="real_corp_id")
    private Long realCorpId; // 项目实际所属公司PK
    @TableField(value="real_corp_name")
    private String realCorpName; // 项目实际所属公司名称
    @TableField(value="apply_id")
    private Long applyId; // 领料主键id
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 上级组织
    @TableField(value="parent_org_name")
    private String parentOrgName; // 上级组织

    @TableField(exist=false)
    @SubEntity(serviceName="outDetailService",pidName = "outId")
    private List<OutDetailEntity> outDetailEntityList = new ArrayList<>();

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public String getSupplyId() {
        return supplyId;
    }

    public void setSupplyId(String supplyId) {
        this.supplyId = supplyId;
    }

    public String getSupplyName() {
        return supplyName;
    }

    public void setSupplyName(String supplyName) {
        this.supplyName = supplyName;
    }

    public String getApplyForDate() {
        return applyForDate;
    }

    public void setApplyForDate(String applyForDate) {
        this.applyForDate = applyForDate;
    }

    public String getOutDate() {
        return outDate;
    }

    public void setOutDate(String outDate) {
        this.outDate = outDate;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Long getPickingId() {
        return pickingId;
    }

    public void setPickingId(Long pickingId) {
        this.pickingId = pickingId;
    }

    public String getPickingName() {
        return pickingName;
    }

    public void setPickingName(String pickingName) {
        this.pickingName = pickingName;
    }

    public Long getOutPersionId() {
        return outPersionId;
    }

    public void setOutPersionId(Long outPersionId) {
        this.outPersionId = outPersionId;
    }

    public String getOutPersionName() {
        return outPersionName;
    }

    public void setOutPersionName(String outPersionName) {
        this.outPersionName = outPersionName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getCoseFlag() {
        return coseFlag;
    }

    public void setCoseFlag(Integer coseFlag) {
        this.coseFlag = coseFlag;
    }

    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public BigDecimal getOutTaxMny() {
        return outTaxMny;
    }

    public void setOutTaxMny(BigDecimal outTaxMny) {
        this.outTaxMny = outTaxMny;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Long getRealCorpId() {
        return realCorpId;
    }

    public void setRealCorpId(Long realCorpId) {
        this.realCorpId = realCorpId;
    }

    public String getRealCorpName() {
        return realCorpName;
    }

    public void setRealCorpName(String realCorpName) {
        this.realCorpName = realCorpName;
    }

    public Long getApplyId() {
        return applyId;
    }

    public void setApplyId(Long applyId) {
        this.applyId = applyId;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public List<OutDetailEntity> getOutDetailEntityList() {
        return outDetailEntityList;
    }

    public void setOutDetailEntityList(List<OutDetailEntity> outDetailEntityList) {
        this.outDetailEntityList = outDetailEntityList;
    }
}
