package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.OutEntity;
import com.ejianc.business.storecloud.service.IOutService;
import com.ejianc.business.storecloud.vo.OutVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
/**
 * 内部领料出库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("out")
public class OutController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi iOrgApi;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutService service;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutVO> saveOrUpdate(@RequestBody OutVO saveOrUpdateVO) {
    	return CommonResponse.success("保存或修改单据成功！",service.saveUpdate(saveOrUpdateVO));
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutVO> queryDetail(Long id) {
    	OutEntity entity = service.selectById(id);
    	OutVO vo = BeanMapper.map(entity, OutVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description scanOut 扫码出库跳转详情
     * @param id
     */
    @RequestMapping(value = "/scanOut", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutVO> scanOut(Long id) {
        OutVO outVO = service.scanOut(id);
        return CommonResponse.success("查询详情数据成功！",outVO);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutVO> vos) {
        service.removeByIds(vos.stream().map(OutVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("storeName");
        fuzzyFields.add("supplyName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("pickingName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        Parameter orgId = param.getParams().get("orgId");
        if(orgId != null ){
            param.getParams().put("orgId",new Parameter(QueryParam.EQ,orgId.getValue()));
        }else{
            throw new BusinessException("网络异常，获取组织失败!");
        }

        if( param.getParams().get("billState") != null){
            param.getParams().remove("billState");
            List<Integer> billState = new ArrayList<>();
            billState.add(0);
            billState.add(2);
            billState.add(4);
            billState.add(5);
            param.getParams().put("billState", new Parameter(QueryParam.IN,billState));
        }else{
            List<Integer> billState = new ArrayList<>();
            billState.add(1);
            billState.add(3);
            param.getParams().put("billState", new Parameter(QueryParam.IN, billState));
        }
        IPage<OutEntity> page = service.queryPage(param,false);
     /*   if(page.getRecords() != null ){
            for(OutEntity outEntity : page.getRecords()){
                if(outEntity.getCoseFlag() == 3){ //等于领料出库，把领料日期显示未出库日期
                    outEntity.setDeliveryDate(outEntity.getApplyForDate());
                }
            }
        }*/
        IPage<OutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutVO.class));
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("MaterialDelivery-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMaterialDeliveryData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutVO>> refMaterialDeliveryData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                String condition,
                                                                String searchObject,
                                                                String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutEntity> page = service.queryPage(param,false);
        IPage<OutVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
