package com.ejianc.business.storecloud.controller;

import java.io.Serializable;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.storecloud.utils.IdCardUtil;
import com.ejianc.business.storecloud.utils.MD5Utils;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.business.storecloud.bean.PersionProjectEntity;
import com.ejianc.business.storecloud.service.IPersionProjectService;
import com.ejianc.business.storecloud.vo.PersionProjectVO;
/**
 * 领料人员
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("persionProject")
public class PersionProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IOrgApi orgApi;

    @Autowired
    private IPersionProjectService service;

    @Autowired
    private IAttachmentApi attachmentApi;


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PersionProjectVO> saveOrUpdate(@RequestBody PersionProjectVO saveOrUpdateVO) {
    	PersionProjectEntity entity = BeanMapper.map(saveOrUpdateVO, PersionProjectEntity.class);
    	entity.setTenantId(InvocationInfoProxy.getTenantid());
    	if(checkcountname(entity.getUserName())){
            throw  new BusinessException("用户名不能为汉字！");
        }
        if(checkUserName(entity.getUserName())){
            throw  new BusinessException("用户名不能有特殊字符！");
        }
        if(!IdCardUtil.isIdcard(entity.getIdNumber())){
            throw  new BusinessException("身份证格式有误,请检查！");
        }
        LambdaQueryWrapper<PersionProjectEntity> queryWrapper = new LambdaQueryWrapper<PersionProjectEntity>();
        queryWrapper.eq(PersionProjectEntity::getUserName, entity.getUserName());
        if (entity.getId()!=null){
            queryWrapper.ne(PersionProjectEntity::getId, entity.getId());
        }
        List<PersionProjectEntity> list = service.list(queryWrapper);
        if (CollectionUtils.isNotEmpty(list)) {
            throw  new BusinessException("用户名已存在，请更换！");
        }
        entity.setFirstFlag(true);
        entity.setUserPwd(MD5Utils.getStringMD5(MD5Utils.getStringMD5("1234Qwer")));//默认密码为"1234Qwer"
    	service.saveOrUpdate(entity, false);
       List<Long> fileIdList = new ArrayList<>();
        CommonResponse<List<AttachmentVO>> commonResponses = attachmentApi.queryListBySourceId(entity.getId(), "EJCBT202208000020", null, null);
        if (commonResponses.isSuccess() && org.apache.commons.collections.CollectionUtils.isNotEmpty(commonResponses.getData())) {
            fileIdList = commonResponses.getData().stream().map(AttachmentVO::getId).collect(Collectors.toList());
            entity.setFileIds(StringUtils.join(fileIdList, ","));
        }
        service.saveOrUpdate(entity, false);
    	PersionProjectVO vo = BeanMapper.map(entity, PersionProjectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PersionProjectVO> queryDetail(Long id) {
    	PersionProjectEntity entity = service.selectById(id);
    	PersionProjectVO vo = BeanMapper.map(entity, PersionProjectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody PersionProjectVO vos) {
        List<Long> ids = vos.getIds();
        service.removeByIds(ids, true);
        return CommonResponse.success("删除成功！");
    }
    /**
     * @Description resetPasswords 生成随机密码并更新用户信息
     * @Param id
     */
    @RequestMapping(value = "/resetPasswords", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> resetPasswords(@RequestBody PersionProjectVO vos) {
        return CommonResponse.success(service.resetPasswords(vos));
    }

    /**
     * @Description updatePwd 修改密码
     * @Param id
     */
    @RequestMapping(value = "/updatePwd", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updatePwd(@RequestBody PersionProjectVO persionProjectVO) {
        service.updatePwd(persionProjectVO);
        return CommonResponse.success("修改密码成功！");
    }


    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryListPro", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PersionProjectVO>> queryListPro(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        IPage<PersionProjectEntity> page = service.queryPage(param,false);
        IPage<PersionProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PersionProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,orgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PersionProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PersionProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPersionProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PersionProjectVO>> refPersionProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PersionProjectEntity> page = service.queryPage(param,false);
        IPage<PersionProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PersionProjectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    public boolean checkcountname(String countname)
    {
        Pattern p = Pattern.compile("[\u4e00-\u9fa5]");
        Matcher m = p.matcher(countname);
        if (m.find()) {
            return true;
        }
        return false;
    }
    // 特殊字符正则校验
    public boolean checkUserName(String userName)
    {
        Pattern p = Pattern.compile("[^a-zA-Z0-9]");
        Matcher m = p.matcher(userName);
        if (m.find()) {
            return true;
        }
        return false;
    }
}
