package com.ejianc.business.storecloud.controller.api;


import com.ejianc.business.storecloud.service.IConfigProjectService;
import com.ejianc.business.storecloud.service.IMaterialProjectService;
import com.ejianc.business.storecloud.vo.ConfigProjectVO;
import com.ejianc.business.storecloud.vo.MaterialProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;

/**
 * 项目云库存
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/configProject")
public class CloudProjectApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IConfigProjectService configProjectService;

    /**
     * @Description
     */
    @RequestMapping(value = "/queryConfigByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ConfigProjectVO> queryConfigByOrgId(@RequestParam(value = "orgId") Long orgId) {
    	return CommonResponse.success("查询数据成功！", configProjectService.queryConfigByOrgId(orgId));
    }

}
