package com.ejianc.business.storecloud.controller.api;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.vo.WarehouseVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import java.io.Serializable;

/**
 * 查询默认仓库
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/warehouse")
public class WarehouseApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IWarehouseService warehouseService;

    @RequestMapping(value = "/queryStoreByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WarehouseVO> queryStoreByProjectId(Long projectId) {
        LambdaQueryWrapper<WarehouseEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(WarehouseEntity::getProjectId, projectId);
        wrapper.eq(WarehouseEntity::getDefaultFlag, 1);
        wrapper.eq(WarehouseEntity::getState, 1);
        WarehouseEntity entity = warehouseService.getOne(wrapper, false);
        return CommonResponse.success("获取默认仓库成功！", null != entity ? BeanMapper.map(entity, WarehouseVO.class) : null);
    }

}
