package com.ejianc.business.storecloud.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.WarehouseFlowEntity;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;

/**
 * 仓库入出流水表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("api/warehouseFlow")
public class WarehouseFlowApiController implements Serializable {
	private static final long serialVersionUID = 1L;

    @Autowired
    private IWarehouseFlowService warehouseFlowService;

    /**
     * @Description push 推送
     */
    @RequestMapping(value = "/push", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> push(@RequestBody WarehouseManageVO manageVO) {
    	return warehouseFlowService.push(manageVO);
    }

    /**
     * @Description rollBack 回退
     */
    @RequestMapping(value = "/rollBack", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> rollBack(@RequestBody WarehouseManageVO manageVO) {
        return warehouseFlowService.rollBack(manageVO);
    }


    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refFlowData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WarehouseFlowVO>> refFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                              String condition,
                                                              String searchObject,
                                                              String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WarehouseFlowEntity> page = warehouseFlowService.queryPage(param,false);
        IPage<WarehouseFlowVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WarehouseFlowVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
