package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.storecloud.bean.*;
import com.ejianc.business.storecloud.service.IApplyService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.ApplyVO;
import com.ejianc.business.storecloud.vo.OutVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.business.storecloud.mapper.OutMapper;
import com.ejianc.business.storecloud.service.IOutService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/**
 * 领料出库
 *
 * @author generator
 *
 */
@Service("outService")
public class OutServiceImpl extends BaseServiceImpl<OutMapper, OutEntity> implements IOutService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IApplyService applyService;

    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IProjectApi iProjectApi;

    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "LING_LIAO";//此处需要根据实际修改

    @Override
    public OutVO saveUpdate(OutVO saveOrUpdateVO) {
        OutEntity entity = BeanMapper.map(saveOrUpdateVO, OutEntity.class);
        entity.setTenantId(InvocationInfoProxy.getTenantid());
        List<Long> projectId = new ArrayList<>();
        projectId.add(entity.getProjectId());
        logger.info("entity.getProjectId()------------------------------------------------------"+entity.getProjectId());
        CommonResponse<List<ProjectRegisterVO>> projectRegisterVO = iProjectApi.queryProjectByIds(projectId);
        if(projectRegisterVO.getCode() == 0 && projectRegisterVO.getData()!= null){
            logger.info("projectRegisterVO.getData().get(0).getProjectDepartmentId()------------------------------------------------------"+projectRegisterVO.getData().get(0).getProjectDepartmentId());
            entity.setOrgId(projectRegisterVO.getData().get(0).getProjectDepartmentId());
            CommonResponse<OrgVO> orgVo = iOrgApi.detailById(entity.getOrgId());
            entity.setOrgCode(orgVo.getData().getCode());
            entity.setOrgName(orgVo.getData().getName());
            if (orgVo.getData().getParentId()!=null){
                entity.setParentOrgId(orgVo.getData().getParentId());
            }else {
                entity.setParentOrgId(entity.getOrgId());
            }
        }else{
            throw new BusinessException("网络异常，未获取到项目部主键");
        }
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        //计算
        BigDecimal outTaxMny = new BigDecimal(0);
        for(OutDetailEntity outDetailEntity : entity.getOutDetailEntityList()){
            outTaxMny = ComputeUtil.safeAdd(outTaxMny,ComputeUtil.safeMultiply(outDetailEntity.getOutNumber(),outDetailEntity.getSurplusTaxPrice()));
            BigDecimal inventoryPrice = ComputeUtil.safeDiv(outDetailEntity.getSurplusTaxMny(),outDetailEntity.getOutNumber());
            outDetailEntity.setInventoryPrice(inventoryPrice);//出库均价
        }
        entity.setOutTaxMny(outTaxMny);
        entity.setSupplyName("中建五局");
        entity.setSupplyId("1328246322863542273");
        saveOrUpdate(entity, false);
        OutVO vo = BeanMapper.map(entity, OutVO.class);
        return vo;
    }

    @Override
    public OutVO scanOut(Long id) {
        //根据id查询领料申请单
        ApplyEntity applyEntity = applyService.selectById(id);
        OutVO outVO = new OutVO();
        if(applyEntity!= null){
            ApplyVO applyVO = BeanMapper.map(applyEntity, ApplyVO.class);
            outVO = BeanMapper.map(applyVO, OutVO.class);
            outVO.setId(null);
            outVO.setCreateTime(null);
            outVO.setUpdateTime(null);
            outVO.setBillCode(null);
            outVO.setCreateUserCode(null);
            outVO.setVersion(1);
            outVO.setStoreName(applyEntity.getStoreName());
            outVO.setApplyForDate(applyVO.getApplyForDate());
            outVO.setStoreId(applyVO.getStoreId());
            outVO.setStoreName(applyVO.getStoreName());
            outVO.setProjectId(applyVO.getProjectId());
            outVO.setProjectName(applyVO.getProjectName());
            outVO.setApplyId(applyVO.getId());
            outVO.setBillState(null);
            List<ApplyDetailEntity> applyDetailEntityList = applyEntity.getApplyDetailEntityList();
            List<OutDetailEntity> outDetailEntityList = new ArrayList<>();
            for(ApplyDetailEntity applyDetailEntity :applyDetailEntityList){
                OutDetailEntity outDetailEntity = BeanMapper.map(applyDetailEntity, OutDetailEntity.class);
                outDetailEntity.setOutId(null);
                outDetailEntity.setOutNumber(applyDetailEntity.getApplyNumber());
                outDetailEntity.setApplyNumber(applyDetailEntity.getApplyNumber());
                outDetailEntity.setApplyDetailId(applyDetailEntity.getId());
                outDetailEntity.setId(null);
                outDetailEntity.setMemo(null);
                //根据仓库，物料查询仓库明细
                LambdaQueryWrapper<WarehouseSurplusEntity> queryWrapper = new LambdaQueryWrapper<WarehouseSurplusEntity>();
                queryWrapper.eq(WarehouseSurplusEntity::getMaterialId, applyDetailEntity.getMaterialId());
                queryWrapper.eq(WarehouseSurplusEntity::getStoreId, applyEntity.getStoreId());
                WarehouseSurplusEntity warehouseSurplusEntity = warehouseSurplusService.getOne(queryWrapper);
                if(warehouseSurplusEntity != null){
                    outDetailEntity.setSurplusNum(warehouseSurplusEntity.getSurplusNum());//库存余量
                    outDetailEntity.setInventoryPrice(warehouseSurplusEntity.getSurplusTaxPrice());// // 库存单价
                    outDetailEntity.setSurplusMny(warehouseSurplusEntity.getSurplusMny());// // 库存单价
                    outDetailEntity.setSurplusTaxMny(warehouseSurplusEntity.getSurplusTaxMny());// // 库存金额含税
                }
                outDetailEntityList.add(outDetailEntity);
            }
            outVO.setOutDetailEntityList(outDetailEntityList);

        }else{
            logger.info("----------------扫码出库跳转详情outVO查询数据为空------------------");
        }
        return outVO;

    }
}
