package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.bean.WarehouseFlowEntity;
import com.ejianc.business.storecloud.bean.WarehouseInoutEntity;
import com.ejianc.business.storecloud.enums.InOutFlagEnum;
import com.ejianc.business.storecloud.enums.InOutTypeEnum;
import com.ejianc.business.storecloud.mapper.WarehouseFlowMapper;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.service.IWarehouseInoutService;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 仓库入出流水表
 *
 * @author generator
 *
 */
@Service("warehouseFlowService")
public class WarehouseFlowServiceImpl extends BaseServiceImpl<WarehouseFlowMapper, WarehouseFlowEntity> implements IWarehouseFlowService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;

    @Autowired
    private IWarehouseService warehouseService;

    @Autowired
    private IWarehouseInoutService warehouseInoutService;

    @Override
    public CommonResponse<String> push(WarehouseManageVO manageVO) {
        logger.info("WarehouseFlowServiceImpl push " + JSON.toJSONString(manageVO));
        List<WarehouseFlowVO> flowVOList = manageVO.getFlowVOList();
        List<Long> detailPkList = flowVOList.stream().map(WarehouseFlowVO::getSourceDetailId).collect(Collectors.toList());
        LambdaQueryWrapper<WarehouseFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(WarehouseFlowEntity::getSourceDetailId, detailPkList);
        List<WarehouseFlowEntity> warehouseFlowEntities = list(queryWrapper);
        if(CollectionUtils.isNotEmpty(warehouseFlowEntities)){
            if(null == manageVO.getType() || 2 != manageVO.getType()){
                return CommonResponse.success("仓库入库流水重复校验：已存在该单据入库流水！");
            }else{
                Map<Long, WarehouseFlowEntity> map = warehouseFlowEntities.stream().collect(Collectors.toMap(WarehouseFlowEntity::getSourceDetailId, Function.identity(), (key1, key2) -> key1));
                for(WarehouseFlowVO flowVO : flowVOList){
                    if (map.containsKey(flowVO.getSourceDetailId())) {
                        WarehouseFlowEntity flowEntity = map.get(flowVO.getSourceDetailId());
                        flowVO.setId(flowEntity.getId());
                        flowVO.setCreateTime(flowEntity.getCreateTime());
                        flowVO.setCreateUserCode(flowEntity.getCreateUserCode());
                        flowVO.setVersion(flowEntity.getVersion());
                    }
                }
            }
        }
        List<WarehouseFlowEntity> flowEntityList = BeanMapper.mapList(flowVOList, WarehouseFlowEntity.class);
        saveOrUpdateBatch(flowEntityList);
        CommonResponse<String> surplusResponse = null;
        if (InOutFlagEnum.入库.getCode().equals(manageVO.getInOutFlag())) {
            surplusResponse = warehouseSurplusService.updateStoreSurplusIn(manageVO, true);
        } else {
            surplusResponse = warehouseSurplusService.updateStoreSurplusOut(manageVO);
            if (!surplusResponse.isSuccess()) {
                return surplusResponse;
            }
            surplusResponse = warehouseInoutService.updateInout(flowEntityList, true);
        }
        return  surplusResponse.isSuccess() ? CommonResponse.success("插入流水成功") : surplusResponse;
    }

    @Override
    public CommonResponse<String> rollBack(WarehouseManageVO manageVO) {
        Integer type = manageVO.getType() == null ? -1 : manageVO.getType();
        logger.info("WarehouseFlowServiceImpl rollBack " + JSON.toJSONString(manageVO));
        LambdaQueryWrapper<WarehouseFlowEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(WarehouseFlowEntity::getSourceDetailId, manageVO.getDelDetailIdList());
        List<WarehouseFlowEntity> flowEntities = list(queryWrapper);
        List<WarehouseFlowVO> flowVOList = BeanMapper.mapList(flowEntities, WarehouseFlowVO.class);
        for(WarehouseFlowVO flowVO : flowVOList){
            flowVO.setMny(ComputeUtil.convertToMinusNumber(flowVO.getMny()));
            flowVO.setTaxMny(ComputeUtil.convertToMinusNumber(flowVO.getTaxMny()));
            flowVO.setNum(ComputeUtil.convertToMinusNumber(flowVO.getNum()));
        }
        manageVO.setFlowVOList(flowVOList);

        CommonResponse<String> surplusResponse = null;
        if (InOutFlagEnum.入库.getCode().equals(manageVO.getInOutFlag())) {
            List<Long> flowIdList = flowEntities.stream().map(WarehouseFlowEntity::getId).collect(Collectors.toList());
            LambdaQueryWrapper<WarehouseInoutEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(WarehouseInoutEntity::getInFlowId, flowIdList);
            if (warehouseInoutService.count(wrapper) > 0) {
                throw new BusinessException("表体含有已出库物资，不允许删除!");
            }
            surplusResponse = warehouseSurplusService.updateStoreSurplusIn(manageVO, false);
        } else {
            surplusResponse = warehouseSurplusService.updateStoreSurplusOut(manageVO);
            if (!surplusResponse.isSuccess()) {
                return surplusResponse;
            }
            surplusResponse = warehouseInoutService.updateInout(flowEntities, false);
        }
        if(2 != type){
            remove(queryWrapper);
        }
        return surplusResponse.isSuccess() ? CommonResponse.success("删除流水成功") : surplusResponse;
    }

    @Override
    public WarehouseFlowVO saveFlow(WarehouseFlowVO flowVO) {
        Long id = IdWorker.getId();
        WarehouseEntity warehouseEntity = warehouseService.selectById(flowVO.getStoreId());
        WarehouseFlowEntity entity = BeanMapper.map(flowVO, WarehouseFlowEntity.class);
        entity.setId(id);
        entity.setBillDate(new Date());
        entity.setProjectId(warehouseEntity.getProjectId());
        entity.setProjectName(warehouseEntity.getProjectName());
        entity.setParentOrgId(warehouseEntity.getParentOrgId());
        entity.setParentOrgCode(warehouseEntity.getParentOrgCode());
        entity.setParentOrgName(warehouseEntity.getParentOrgName());
        entity.setOrgId(warehouseEntity.getOrgId());
        entity.setOrgName(warehouseEntity.getOrgName());
        entity.setStoreName(warehouseEntity.getWarehouseName());
        entity.setInOutFlag(InOutFlagEnum.入库.getCode());
        entity.setInOutType(InOutTypeEnum.期初入库.getCode());
        entity.setInOutTypeName("期初入库");
        entity.setTaxPrice(ComputeUtil.safeDiv(entity.getTaxMny(), entity.getNum()));
        entity.setSourceBillCode(String.valueOf(id));
        entity.setSourceBillDate(new Date());
        entity.setSourceBillTypeCode("EJCBT202208000016");
        entity.setSourceBillTypeName("仓库流水");
        entity.setSourceDetailId(id);
        entity.setSourceId(id);
        entity.setSourceType(0);
        saveOrUpdate(entity);
        WarehouseFlowVO warehouseFlowVO = BeanMapper.map(entity, WarehouseFlowVO.class);
        WarehouseManageVO manageVO = new WarehouseManageVO();
        manageVO.setProjectId(entity.getProjectId());
        manageVO.setStoreId(entity.getStoreId());
        manageVO.setInOutFlag(entity.getInOutFlag());
        manageVO.setFlowVOList(Arrays.asList(warehouseFlowVO));
        warehouseSurplusService.updateStoreSurplusIn(manageVO, true);
        return warehouseFlowVO;
    }
}
