/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.mapper.WarehouseMapper;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.utils.WeChatUtil;
import com.ejianc.business.storecloud.vo.WarehouseVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentRequestVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="warehouseService")
public class WarehouseServiceImpl
extends BaseServiceImpl<WarehouseMapper, WarehouseEntity>
implements IWarehouseService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private WeChatUtil weChatUtil;
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    private static final String BILL_CODE = "WAREHOUSE_CODE";

    @Override
    public WarehouseVO saveWarehouse(WarehouseVO saveOrUpdateVO) {
        WarehouseEntity entity = (WarehouseEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), WarehouseEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (!billCode.isSuccess()) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            entity.setBillCode((String)billCode.getData());
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(WarehouseEntity::getProjectId, (Object)entity.getProjectId());
            queryWrapper.eq(WarehouseEntity::getWarehouseName, (Object)entity.getWarehouseName());
            if (CollectionUtils.isNotEmpty((Collection)this.list((Wrapper)queryWrapper))) {
                throw new BusinessException("\u4ed3\u5e93\u540d\u5728\u8be5\u9879\u76ee\u4e0b\u5df2\u5b58\u5728\uff01");
            }
        }
        this.updateDefaultFlag(entity.getProjectId(), entity.getId(), entity.getDefaultFlag());
        this.saveOrUpdate((Object)entity, false);
        return (WarehouseVO)((Object)BeanMapper.map((Object)((Object)entity), WarehouseVO.class));
    }

    @Override
    public WarehouseVO createQRCode(Long id) {
        WarehouseEntity warehouseEntity = (WarehouseEntity)((Object)this.selectById(id));
        String accessroken = "";
        if (null == this.redisTemplate.opsForValue().get((Object)"sc_access_token")) {
            accessroken = this.weChatUtil.getAccesstoken();
            if (!StringUtils.isEmpty((CharSequence)accessroken)) {
                this.redisTemplate.opsForValue().set((Object)"sc_access_token", (Object)accessroken, 90L, TimeUnit.MINUTES);
            }
            this.logger.info("\u83b7\u53d6accessroken:" + accessroken);
        } else {
            accessroken = this.redisTemplate.opsForValue().get((Object)"sc_access_token").toString();
            this.logger.info("\u83b7\u53d6accessroken:=====" + accessroken);
        }
        String path = "applyCard?storeId=" + id;
        String multipartFile = this.weChatUtil.createLongQRCodeStr(path, String.valueOf(id), accessroken);
        String baseAddr = null;
        if (this.baseHost.contains("17elian")) {
            baseAddr = "http://dev-ejc-attachment.oss-cn-beijing.aliyuncs.com/";
        } else if (this.baseHost.contains("9082")) {
            baseAddr = "http://wei.cscec5b.com.cn:9082/";
        } else if (this.baseHost.contains("9080")) {
            baseAddr = "http://wei.cscec5b.com.cn:9080/";
        }
        warehouseEntity.setQrcode(baseAddr + this.dealImg(multipartFile, warehouseEntity));
        this.saveOrUpdate((Object)warehouseEntity);
        return (WarehouseVO)((Object)BeanMapper.map((Object)((Object)warehouseEntity), WarehouseVO.class));
    }

    private void updateDefaultFlag(Long projectId, Long id, Boolean defaultFlag) {
        if (BooleanUtils.isTrue((Boolean)defaultFlag)) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(WarehouseEntity::getProjectId, (Object)projectId);
            updateWrapper.ne(null != id, BaseEntity::getId, (Object)id);
            updateWrapper.set(WarehouseEntity::getDefaultFlag, (Object)false);
            this.update((Wrapper)updateWrapper);
        }
    }

    private String dealImg(String file, WarehouseEntity warehouseEntity) {
        AttachmentRequestVO attachmentVO = new AttachmentRequestVO();
        attachmentVO.setBillType("EJCBT202208000014");
        attachmentVO.setSourceId(String.valueOf(warehouseEntity.getId()));
        attachmentVO.setSourceType("EJCBT202208000014");
        attachmentVO.setFileList(Arrays.asList(file));
        attachmentVO.setProjectcode(warehouseEntity.getProjectCode());
        this.logger.info(JSON.toJSONString((Object)attachmentVO));
        CommonResponse listCommonResponse = this.attachmentApi.uploadForBase64(attachmentVO);
        this.logger.info("\u56fe\u7247\u5217\u8868\u6570\u636e\u524d:" + listCommonResponse.getData());
        if (listCommonResponse.isSuccess()) {
            return ((AttachmentVO)((List)listCommonResponse.getData()).get(0)).getFilePath();
        }
        return null;
    }
}

