/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.bean.WarehouseEntity;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.service.IWarehouseService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseSurplusQueryVO;
import com.ejianc.business.storecloud.vo.WarehouseSurplusVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"warehouseSurplus"})
public class WarehouseSurplusController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IWarehouseSurplusService surplusService;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IWarehouseService warehouseService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WarehouseSurplusVO> saveOrUpdate(@RequestBody WarehouseSurplusVO saveOrUpdateVO) {
        WarehouseSurplusEntity entity = (WarehouseSurplusEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), WarehouseSurplusEntity.class));
        this.surplusService.saveOrUpdate((Object)entity, false);
        WarehouseSurplusVO vo = (WarehouseSurplusVO)((Object)BeanMapper.map((Object)((Object)entity), WarehouseSurplusVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WarehouseSurplusVO> queryDetail(Long id) {
        WarehouseSurplusEntity entity = (WarehouseSurplusEntity)((Object)this.surplusService.selectById(id));
        WarehouseSurplusVO vo = (WarehouseSurplusVO)((Object)BeanMapper.map((Object)((Object)entity), WarehouseSurplusVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WarehouseSurplusVO> vos) {
        List longList = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        List surplusEntities = (List)this.surplusService.listByIds(longList);
        for (WarehouseSurplusEntity surplusEntity : surplusEntities) {
            if (!ComputeUtil.isGreaterThan((BigDecimal)surplusEntity.getOutLockNum(), (BigDecimal)BigDecimal.ZERO)) continue;
            throw new BusinessException("\u7269\u8d44\u3010" + surplusEntity.getMaterialName() + "\u3011\u5df2\u53d1\u751f\u51fa\u5e93\uff0c\u4e0d\u5141\u8bb8\u5220\u9664!");
        }
        BigDecimal surplusTaxMny = new BigDecimal(0);
        Long storeId = null;
        for (WarehouseSurplusEntity surplusEntity : surplusEntities) {
            storeId = surplusEntity.getStoreId();
            surplusTaxMny = ComputeUtil.safeAdd((BigDecimal)surplusTaxMny, (BigDecimal)surplusEntity.getSurplusTaxMny());
        }
        if (storeId != null) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(BaseEntity::getId, (Object)storeId);
            WarehouseEntity warehouseEntity = (WarehouseEntity)((Object)this.warehouseService.getOne((Wrapper)queryWrapper));
            if (warehouseEntity != null) {
                LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
                updateWrapper.set(WarehouseEntity::getTotalMny, (Object)ComputeUtil.safeSub((BigDecimal)warehouseEntity.getTotalMny(), (BigDecimal)surplusTaxMny));
                updateWrapper.eq(BaseEntity::getId, (Object)storeId);
                Boolean flag = this.warehouseService.update((Wrapper)updateWrapper);
                if (!flag.booleanValue()) {
                    throw new BusinessException("\u56de\u5199\u4ed3\u5e93\u91d1\u989d\u5931\u8d25!");
                }
            }
        }
        this.surplusService.removeByIds(longList, true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WarehouseSurplusVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("materialName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (param.getParams().containsKey("categoryId")) {
            param.getParams().put("materialCategoryInnerCode", new Parameter("like", ((Parameter)param.getParams().get("categoryId")).getValue()));
            param.getParams().remove("categoryId");
        }
        param.getParams().put("surplusNum", new Parameter("gt", (Object)0));
        IPage page = this.surplusService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WarehouseSurplusVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refSurplusData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WarehouseSurplusVO>> refSurplusData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject conjson;
        QueryParam param = new QueryParam();
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialCode");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("surplusNum", new Parameter("gt", (Object)0));
        if (StringUtils.isNotEmpty((CharSequence)condition) && null != (conjson = JSONObject.parseObject((String)condition)).get((Object)"storeId")) {
            param.getParams().put("storeId", new Parameter("eq", conjson.get((Object)"storeId")));
        }
        IPage page = this.surplusService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List warehouseSurplusVOS = BeanMapper.mapList((Iterable)page.getRecords(), WarehouseSurplusVO.class);
        for (WarehouseSurplusVO surplusVO : warehouseSurplusVOS) {
            CommonResponse response;
            if (!StringUtils.isNotEmpty((CharSequence)surplusVO.getFileIds()) || !(response = this.attachmentApi.queryDetail(surplusVO.getFileIds().split(",")[0])).isSuccess() || null == response.getData()) continue;
            surplusVO.setMainUrl(((AttachmentVO)response.getData()).getFilePath());
        }
        pageData.setRecords(warehouseSurplusVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/lazyMaterialCategory"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<List<MaterialCategoryVO>> lazyMaterialCategory(@RequestParam(value="parentId", required=false) Long parentId, @RequestParam(value="storeId") Long storeId) {
        ArrayList<MaterialCategoryVO> materialCategoryVO;
        block4: {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)storeId);
            queryWrapper.like(null != parentId, WarehouseSurplusEntity::getMaterialCategoryInnerCode, (Object)parentId);
            List surplusEntities = this.surplusService.list((Wrapper)queryWrapper);
            materialCategoryVO = new ArrayList<MaterialCategoryVO>();
            if (!CollectionUtils.isNotEmpty((Collection)surplusEntities)) break block4;
            List categoryIdList = surplusEntities.stream().map(WarehouseSurplusEntity::getMaterialCategoryId).collect(Collectors.toList());
            CommonResponse materialCategoryVOS = this.materialApi.queryCategoryListByChildren(categoryIdList);
            List dateList = (List)materialCategoryVOS.getData();
            if (parentId != null) {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() == null || !materialCategoryVO1.getParentId().equals(parentId)) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            } else {
                for (MaterialCategoryVO materialCategoryVO1 : dateList) {
                    if (materialCategoryVO1.getParentId() != null) continue;
                    materialCategoryVO.add(materialCategoryVO1);
                }
            }
        }
        return CommonResponse.success(materialCategoryVO);
    }

    @RequestMapping(value={"/queryByStoreMateList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<WarehouseSurplusVO>> queryByStoreMateList(@RequestBody WarehouseSurplusQueryVO queryVO) {
        if (null == queryVO.getStoreId()) {
            throw new BusinessException("\u4ed3\u5e93\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", this.surplusService.queryByStoreMateList(queryVO));
    }

    @RequestMapping(value={"/download"})
    @ResponseBody
    public void download(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"WarehouseSurplus-import.xlsx", (String)"\u4ed3\u5e93\u7ba1\u7406\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelImport(HttpServletRequest request, HttpServletResponse response) {
        return this.surplusService.excelImport(request, response);
    }

    @RequestMapping(value={"/saveImportExcel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> saveImportExcel(String storeId, HttpServletRequest request, @RequestBody List<WarehouseFlowVO> importVOS) {
        return CommonResponse.success((String)((String)this.surplusService.saveImportExcel(storeId, request, importVOS)));
    }

    @RequestMapping(value={"/updateMemo"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WarehouseSurplusVO> updateMemo(@RequestBody WarehouseSurplusVO surplusVO) {
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(BaseEntity::getId, (Object)surplusVO.getId());
        wrapper.set(WarehouseSurplusEntity::getMemo, (Object)surplusVO.getMemo());
        this.surplusService.update((Wrapper)wrapper);
        return CommonResponse.success((String)"\u66f4\u65b0\u8bf4\u660e\u6210\u529f\uff01", (Object)BeanMapper.map((Object)this.surplusService.selectById(surplusVO.getId()), WarehouseSurplusVO.class));
    }
}

