/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.storecloud.bean.CheckDetailEntity;
import com.ejianc.business.storecloud.bean.CheckEntity;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.mapper.CheckMapper;
import com.ejianc.business.storecloud.service.ICheckService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.CheckVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "CHECK_CODE";
    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;

    @Override
    public CheckVO saveCheckStore(CheckVO saveOrUpdateVO) {
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.eq(CheckEntity::getStoreId, (Object)saveOrUpdateVO.getStoreId());
        checkWrapper.gt(CheckEntity::getCheckDate, (Object)saveOrUpdateVO.getCheckDate());
        if (CollectionUtils.isNotEmpty((Collection)this.list((Wrapper)checkWrapper))) {
            throw new BusinessException("\u8be5\u65f6\u95f4\u70b9\u540e\u5df2\u53d1\u751f\u4ed3\u5e93\u76d8\u70b9\u5355");
        }
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, CheckEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse codeBatchByRuleCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (codeBatchByRuleCode.isSuccess()) {
                entity.setBillCode((String)codeBatchByRuleCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(null != entity.getId(), BaseEntity::getId, (Object)entity.getId());
        wrapper.eq(CheckEntity::getProjectId, (Object)entity.getProjectId());
        wrapper.eq(CheckEntity::getStoreId, (Object)entity.getStoreId());
        wrapper.eq(CheckEntity::getBillState, (Object)BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        List list = super.list((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            throw new BusinessException("\u8be5\u4ed3\u5e93\u5df2\u4e0b\u5b58\u5728\u81ea\u7531\u6001\u76d8\u70b9\u5355\uff01");
        }
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList subList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                subList.add(item);
            }
        });
        if (CollectionUtils.isNotEmpty(subList)) {
            HashMap checkMap = new HashMap();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.gt(WarehouseSurplusEntity::getSurplusNum, (Object)0);
            queryWrapper.eq(WarehouseSurplusEntity::getProjectId, (Object)entity.getProjectId());
            queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)entity.getStoreId());
            queryWrapper.in(WarehouseSurplusEntity::getMaterialId, (Collection)subList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toSet()));
            List surplusEntities = this.warehouseSurplusService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)surplusEntities)) {
                surplusEntities.forEach(item -> checkMap.put(item.getMaterialId(), item));
            }
            for (CheckDetailEntity item2 : subList) {
                WarehouseSurplusEntity surplusEntity = (WarehouseSurplusEntity)((Object)checkMap.get(item2.getMaterialId()));
                if (null == surplusEntity) {
                    throw new BusinessException("\u3010" + item2.getMaterialName() + "_" + item2.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355,\u4e0d\u53ef\u4fdd\u5b58");
                }
                if (!ComputeUtil.isLessThan((BigDecimal)ComputeUtil.safeAdd((BigDecimal)item2.getInventory(), (BigDecimal)surplusEntity.getSurplusNum()), (BigDecimal)BigDecimal.ZERO)) continue;
                throw new BusinessException("\u3010" + item2.getMaterialName() + "_" + item2.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355,\u4e0d\u53ef\u4fdd\u5b58");
            }
        }
        this.saveOrUpdate((Object)entity, false);
        return (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
    }

    @Override
    public CommonResponse<String> checkByDate(Long storeId, String checkDate) {
        LambdaQueryWrapper checkWrapper = new LambdaQueryWrapper();
        checkWrapper.eq(CheckEntity::getStoreId, (Object)storeId);
        checkWrapper.gt(CheckEntity::getCheckDate, (Object)checkDate);
        if (CollectionUtils.isNotEmpty((Collection)this.list((Wrapper)checkWrapper))) {
            throw new BusinessException("\u8be5\u65f6\u95f4\u70b9\u540e\u5df2\u53d1\u751f\u4ed3\u5e93\u76d8\u70b9\u5355");
        }
        return CommonResponse.success();
    }
}

