/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.storecloud.vo.WechatQRCodeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import sun.misc.BASE64Encoder;

@Component
public class WeChatUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${wechat.mpAppId}")
    private String mpAppId;
    @Value(value="${wechat.mpAppSecret}")
    private String mpAppSecret;
    private static final int LONG_CODE_WIDTH = 430;
    private static final int SHORT_CODE_WIDTH = 280;

    public Map<String, String> oauth2GetOpenid(String code) {
        String grant_type = "authorization_code";
        String requestUrl = "https://api.weixin.qq.com/sns/jscode2session";
        String params = "appid=" + this.mpAppId + "&secret=" + this.mpAppSecret + "&js_code=" + code + "&grant_type=" + grant_type;
        this.logger.debug("get openid begin time  is " + new Date());
        String data = HttpUtils.get((String)(requestUrl + "?" + params));
        this.logger.debug("get openid end time  is " + new Date());
        JSONObject returnJson = JSON.parseObject((String)data);
        HashMap<String, String> result = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)returnJson.getString("openid"))) {
            throw new BusinessException("\u83b7\u53d6openid\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        result.put("openid", returnJson.getString("openid"));
        return result;
    }

    public String getAccesstoken() {
        String url = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=" + this.mpAppId + "&secret=" + this.mpAppSecret;
        this.logger.info("get accesstoken begin time  is " + new Date());
        String data = HttpUtils.get((String)url);
        this.logger.info("get accesstoken url  is " + url);
        this.logger.info("get accesstoken end time  is " + new Date());
        JSONObject returnJson = JSON.parseObject((String)data);
        return returnJson.getString("access_token");
    }

    public MultipartFile createLongQRCode(String path, String name, String accessToken) {
        WechatQRCodeVO wechatQRCodeVO = new WechatQRCodeVO();
        wechatQRCodeVO.setPath(path);
        wechatQRCodeVO.setWidth(430);
        String url = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" + accessToken;
        this.logger.info("createLongQRCode begin time  is " + new Date());
        InputStream inputStream = HttpUtils.download((String)url, (String)JSONObject.toJSONString((Object)wechatQRCodeVO));
        this.logger.info("createLongQRCode end time  is " + new Date());
        try {
            return new MockMultipartFile(name + ".jpeg", name + ".jpeg", "image/jpeg", inputStream);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public String createLongQRCodeStr(String path, String name, String accessToken) {
        WechatQRCodeVO wechatQRCodeVO = new WechatQRCodeVO();
        wechatQRCodeVO.setPath(path);
        wechatQRCodeVO.setWidth(430);
        String url = "https://api.weixin.qq.com/cgi-bin/wxaapp/createwxaqrcode?access_token=" + accessToken;
        InputStream inputStream = HttpUtils.download((String)url, (String)JSONObject.toJSONString((Object)wechatQRCodeVO));
        this.logger.info("createLongQRCode begin time  is " + url);
        this.logger.info("createLongQRCode end time  is " + JSONObject.toJSONString((Object)wechatQRCodeVO));
        try {
            MockMultipartFile multipartFile = new MockMultipartFile(name + ".jpeg", name + ".jpeg", "image/jpeg", inputStream);
            String baseStr = null;
            File file = new File(multipartFile.getOriginalFilename());
            FileUtils.copyInputStreamToFile((InputStream)multipartFile.getInputStream(), (File)file);
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            fileInputStream.read(buffer);
            fileInputStream.close();
            baseStr = new BASE64Encoder().encode(buffer);
            if (file.exists()) {
                file.delete();
            }
            baseStr = baseStr.replaceAll("\r\n", "");
            return baseStr;
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }

    public MultipartFile createShortQRCode(String page, String scene, String name, String accessToken) {
        WechatQRCodeVO wechatQRCodeVO = new WechatQRCodeVO();
        wechatQRCodeVO.setPage(page);
        wechatQRCodeVO.setScene(scene);
        wechatQRCodeVO.setWidth(280);
        String url = "https://api.weixin.qq.com/wxa/getwxacodeunlimit?access_token=" + accessToken;
        this.logger.info("createShortQRCode begin time  is " + new Date());
        InputStream inputStream = HttpUtils.download((String)url, (String)JSONObject.toJSONString((Object)wechatQRCodeVO));
        this.logger.info("createShortQRCode end time  is " + new Date());
        try {
            return new MockMultipartFile(name + ".jpeg", name + ".jpeg", "image/jpeg", inputStream);
        }
        catch (IOException e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }
}

