/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"api/warehouseFlow"})
public class WarehouseFlowApiController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IWarehouseFlowService warehouseFlowService;

    @RequestMapping(value={"/push"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> push(@RequestBody WarehouseManageVO manageVO) {
        return this.warehouseFlowService.push(manageVO);
    }

    @RequestMapping(value={"/rollBack"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> rollBack(@RequestBody WarehouseManageVO manageVO) {
        return this.warehouseFlowService.rollBack(manageVO);
    }

    @RequestMapping(value={"/refFlowData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<WarehouseFlowVO>> refFlowData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.warehouseFlowService.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), WarehouseFlowVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

