/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.storecloud.bean.CheckDetailEntity;
import com.ejianc.business.storecloud.bean.CheckEntity;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.enums.InOutFlagEnum;
import com.ejianc.business.storecloud.enums.InOutTypeEnum;
import com.ejianc.business.storecloud.service.ICheckService;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="check")
public class CheckBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private ICheckService checkService;
    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;
    @Autowired
    private IWarehouseFlowService warehouseFlowService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.pushToStore(billId);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CheckEntity checkEntity = (CheckEntity)((Object)this.checkService.selectById(billId));
        String checkDate = DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)checkEntity.getCheckDate());
        String createTime = DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)checkEntity.getCreateTime());
        QueryWrapper checkWrapper = new QueryWrapper();
        checkWrapper.eq((Object)"store_id", (Object)checkEntity.getStoreId());
        checkWrapper.apply(" (check_date > '" + checkDate + "' or (check_date = '" + checkDate + "' and create_time > '" + createTime + "'))", new Object[0]);
        List checkList = this.checkService.list((Wrapper)checkWrapper);
        if (CollectionUtils.isNotEmpty((Collection)checkList)) {
            throw new BusinessException("\u8be5\u76d8\u70b9\u5355\u540e\u5df2\u5b58\u5728\u76d8\u70b9\u5355\uff0c\u65e0\u6cd5\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.rollBackStore(billId);
        return CommonResponse.success();
    }

    private void pushToStore(Long billId) {
        ArrayList<WarehouseFlowVO> flowVOS;
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList inList = new ArrayList();
        ArrayList outList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                inList.add(item);
            }
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                outList.add(item);
            }
        });
        if (CollectionUtils.isNotEmpty(outList)) {
            flowVOS = new ArrayList<WarehouseFlowVO>();
            HashMap checkMap = new HashMap();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.gt(WarehouseSurplusEntity::getSurplusNum, (Object)0);
            queryWrapper.eq(WarehouseSurplusEntity::getProjectId, (Object)entity.getProjectId());
            queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)entity.getStoreId());
            queryWrapper.in(WarehouseSurplusEntity::getMaterialId, (Collection)outList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toSet()));
            List surplusEntities = this.warehouseSurplusService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isNotEmpty((Collection)surplusEntities)) {
                surplusEntities.forEach(item -> checkMap.put(item.getMaterialId(), item));
            }
            for (CheckDetailEntity item2 : outList) {
                WarehouseSurplusEntity surplusEntity = (WarehouseSurplusEntity)((Object)checkMap.get(item2.getMaterialId()));
                if (null == surplusEntity) {
                    throw new BusinessException("\u3010" + item2.getMaterialName() + "_" + item2.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355");
                }
                if (ComputeUtil.isLessThan((BigDecimal)ComputeUtil.safeAdd((BigDecimal)item2.getInventory(), (BigDecimal)surplusEntity.getSurplusNum()), (BigDecimal)BigDecimal.ZERO)) {
                    throw new BusinessException("\u3010" + item2.getMaterialName() + "_" + item2.getSpec() + "\u3011\u5e93\u5b58\u53ef\u7528\u6570\u91cf\u4e0d\u8db3\uff0c\u65e0\u6cd5\u5f62\u6210\u76d8\u4e8f\u51fa\u5e93\u5355");
                }
                if (item2.getInventory() == null) {
                    item2.setInventory(BigDecimal.ZERO);
                }
                WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
                warehouseFlowVO.setInOutFlag(InOutFlagEnum.\u51fa\u5e93.getCode());
                warehouseFlowVO.setInOutType(InOutTypeEnum.\u76d8\u4e8f\u51fa\u5e93.getCode());
                warehouseFlowVO.setBillCode(entity.getBillCode());
                warehouseFlowVO.setBillDate(entity.getCreateTime());
                warehouseFlowVO.setProjectId(entity.getProjectId());
                warehouseFlowVO.setProjectName(entity.getProjectName());
                warehouseFlowVO.setParentOrgId(entity.getParentOrgId());
                CommonResponse orgVO = this.orgApi.getOneById(entity.getParentOrgId());
                warehouseFlowVO.setParentOrgCode(((OrgVO)orgVO.getData()).getCode());
                warehouseFlowVO.setParentOrgName(((OrgVO)orgVO.getData()).getName());
                warehouseFlowVO.setOrgId(entity.getOrgId());
                warehouseFlowVO.setOrgName(entity.getOrgName());
                warehouseFlowVO.setStoreId(entity.getStoreId());
                warehouseFlowVO.setStoreName(entity.getStoreName());
                warehouseFlowVO.setEmployeeId(entity.getEmployeeId());
                warehouseFlowVO.setEmployeeName(entity.getEmployeeName());
                warehouseFlowVO.setInOutTypeName("\u76d8\u4e8f\u51fa\u5e93");
                warehouseFlowVO.setMaterialCategoryId(item2.getMaterialCategoryId());
                warehouseFlowVO.setMaterialCategoryName(item2.getMaterialCategoryName());
                warehouseFlowVO.setSourceBillDate(item2.getCreateTime());
                warehouseFlowVO.setSourceBillTypeCode("BT221116000000001");
                warehouseFlowVO.setSourceBillTypeName("\u4ed3\u5e93\u76d8\u70b9");
                warehouseFlowVO.setSourceId(entity.getId());
                warehouseFlowVO.setSourceDetailId(item2.getId());
                warehouseFlowVO.setSourceBillCode(entity.getBillCode());
                warehouseFlowVO.setMaterialId(item2.getMaterialId());
                warehouseFlowVO.setMaterialName(item2.getMaterialName());
                warehouseFlowVO.setMaterialCode(item2.getMaterialCode());
                warehouseFlowVO.setMaterialTypeName(item2.getMaterialCategoryName());
                warehouseFlowVO.setMaterialSpec(item2.getSpec());
                warehouseFlowVO.setMaterialUnitName(item2.getUnitName());
                warehouseFlowVO.setNum(ComputeUtil.safeSub((BigDecimal)BigDecimal.ZERO, (BigDecimal)item2.getInventory()));
                warehouseFlowVO.setTaxMny(item2.getInventoryMny());
                warehouseFlowVO.setMny(item2.getInventoryTaxMny());
                warehouseFlowVO.setTaxPrice(item2.getTaxPrice());
                warehouseFlowVO.setPrice(item2.getPrice());
                warehouseFlowVO.setTax(ComputeUtil.safeSub((BigDecimal)item2.getInventoryTaxMny(), (BigDecimal)item2.getInventoryMny()));
                flowVOS.add(warehouseFlowVO);
            }
            WarehouseManageVO storeManageVO = new WarehouseManageVO();
            storeManageVO.setProjectId(entity.getProjectId());
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutFlag(InOutFlagEnum.\u51fa\u5e93.getCode());
            storeManageVO.setFlowVOList(flowVOS);
            this.warehouseFlowService.push(storeManageVO);
        }
        if (CollectionUtils.isNotEmpty(inList)) {
            flowVOS = new ArrayList();
            for (CheckDetailEntity item3 : inList) {
                WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
                warehouseFlowVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
                warehouseFlowVO.setInOutType(InOutTypeEnum.\u76d8\u76c8\u5165\u5e93.getCode());
                warehouseFlowVO.setBillCode(entity.getBillCode());
                warehouseFlowVO.setBillDate(entity.getCreateTime());
                warehouseFlowVO.setProjectId(entity.getProjectId());
                warehouseFlowVO.setProjectName(entity.getProjectName());
                warehouseFlowVO.setParentOrgId(entity.getParentOrgId());
                CommonResponse orgVO = this.orgApi.getOneById(entity.getParentOrgId());
                warehouseFlowVO.setParentOrgCode(((OrgVO)orgVO.getData()).getCode());
                warehouseFlowVO.setParentOrgName(((OrgVO)orgVO.getData()).getName());
                warehouseFlowVO.setOrgId(entity.getOrgId());
                warehouseFlowVO.setOrgName(entity.getOrgName());
                warehouseFlowVO.setStoreId(entity.getStoreId());
                warehouseFlowVO.setStoreName(entity.getStoreName());
                warehouseFlowVO.setEmployeeId(entity.getEmployeeId());
                warehouseFlowVO.setEmployeeName(entity.getEmployeeName());
                warehouseFlowVO.setInOutTypeName("\u76d8\u76c8\u5165\u5e93");
                warehouseFlowVO.setMaterialCategoryId(item3.getMaterialCategoryId());
                warehouseFlowVO.setMaterialCategoryName(item3.getMaterialCategoryName());
                warehouseFlowVO.setSourceBillDate(item3.getCreateTime());
                warehouseFlowVO.setSourceBillTypeCode("BT221116000000001");
                warehouseFlowVO.setSourceBillTypeName("\u4ed3\u5e93\u76d8\u70b9");
                warehouseFlowVO.setSourceId(entity.getId());
                warehouseFlowVO.setSourceDetailId(item3.getId());
                warehouseFlowVO.setSourceBillCode(entity.getBillCode());
                warehouseFlowVO.setMaterialId(item3.getMaterialId());
                warehouseFlowVO.setMaterialName(item3.getMaterialName());
                warehouseFlowVO.setMaterialCode(item3.getMaterialCode());
                warehouseFlowVO.setMaterialTypeName(item3.getMaterialCategoryName());
                warehouseFlowVO.setMaterialSpec(item3.getSpec());
                warehouseFlowVO.setMaterialUnitName(item3.getUnitName());
                warehouseFlowVO.setNum(item3.getInventory());
                warehouseFlowVO.setTaxMny(item3.getInventoryMny());
                warehouseFlowVO.setMny(item3.getInventoryTaxMny());
                warehouseFlowVO.setTaxPrice(item3.getTaxPrice());
                warehouseFlowVO.setPrice(item3.getPrice());
                warehouseFlowVO.setTax(ComputeUtil.safeSub((BigDecimal)item3.getInventoryTaxMny(), (BigDecimal)item3.getInventoryMny()));
                flowVOS.add(warehouseFlowVO);
            }
            WarehouseManageVO storeManageVO = new WarehouseManageVO();
            storeManageVO.setProjectId(entity.getProjectId());
            storeManageVO.setStoreId(entity.getStoreId());
            storeManageVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
            storeManageVO.setFlowVOList(flowVOS);
            this.warehouseFlowService.push(storeManageVO);
        }
    }

    private void rollBackStore(Long billId) {
        WarehouseManageVO manageVO;
        CheckEntity entity = (CheckEntity)((Object)this.checkService.selectById(billId));
        List<CheckDetailEntity> checkSubList = entity.getCheckSubList();
        ArrayList inList = new ArrayList();
        ArrayList outList = new ArrayList();
        checkSubList.forEach(item -> {
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) > 0) {
                inList.add(item.getId());
            }
            if (item.getInventory() != null && item.getInventory().compareTo(BigDecimal.ZERO) < 0) {
                outList.add(item.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(inList)) {
            manageVO = new WarehouseManageVO();
            manageVO.setProjectId(entity.getProjectId());
            manageVO.setStoreId(entity.getStoreId());
            manageVO.setInOutFlag(InOutFlagEnum.\u5165\u5e93.getCode());
            manageVO.setDelDetailIdList(inList);
            this.warehouseFlowService.rollBack(manageVO);
        }
        if (CollectionUtils.isNotEmpty(outList)) {
            manageVO = new WarehouseManageVO();
            manageVO.setProjectId(entity.getProjectId());
            manageVO.setStoreId(entity.getStoreId());
            manageVO.setInOutFlag(InOutFlagEnum.\u51fa\u5e93.getCode());
            manageVO.setDelDetailIdList(outList);
            this.warehouseFlowService.rollBack(manageVO);
        }
    }
}

