/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.storecloud.bean.MaterialOrgEntity;
import com.ejianc.business.storecloud.mapper.MaterialOrgMapper;
import com.ejianc.business.storecloud.service.IMaterialOrgService;
import com.ejianc.business.storecloud.vo.MaterialOrgVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="materialOrgService")
public class MaterialOrgServiceImpl
extends BaseServiceImpl<MaterialOrgMapper, MaterialOrgEntity>
implements IMaterialOrgService {
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IMaterialOrgService service;

    @Override
    public List<MaterialOrgVO> saveOrUpdate(List<MaterialOrgVO> saveOrUpdateVO) {
        ArrayList<MaterialOrgVO> vo = new ArrayList<MaterialOrgVO>();
        ArrayList list = new ArrayList();
        for (MaterialOrgVO materialOrgVO : saveOrUpdateVO) {
            if (materialOrgVO.getId() != null) {
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(MaterialOrgEntity::getMaterialId, (Object)materialOrgVO.getId());
                queryWrapper.eq(MaterialOrgEntity::getOrgId, (Object)InvocationInfoProxy.getOrgId());
                queryWrapper.eq(BaseEntity::getDr, (Object)0);
                List materialOrgVOS = super.list((Wrapper)queryWrapper);
                if (CollectionUtils.isNotEmpty((Collection)materialOrgVOS)) {
                    throw new BusinessException("\u7f16\u53f7\u4e3a" + materialOrgVO.getCode() + "\u7684\u7269\u8d44\u5df2\u88ab\u5f15\u7528\uff01");
                }
            }
            CommonResponse materialCategoryVO = this.materialApi.queryCategoryById(materialOrgVO.getCategoryId());
            materialOrgVO.setCategoryInnerCode(((MaterialCategoryVO)materialCategoryVO.getData()).getInnerCode());
            materialOrgVO.setMaterialId(materialOrgVO.getId());
            materialOrgVO.setMaterialCode(materialOrgVO.getCode());
            materialOrgVO.setMaterialName(materialOrgVO.getName());
            materialOrgVO.setUnit(materialOrgVO.getUnitName());
            materialOrgVO.setOrgId(InvocationInfoProxy.getOrgId());
            CommonResponse orgVo = this.iOrgApi.detailById(materialOrgVO.getOrgId());
            materialOrgVO.setOrgCode(((OrgVO)orgVo.getData()).getCode());
            materialOrgVO.setOrgName(((OrgVO)orgVo.getData()).getName());
            materialOrgVO.setParentOrgId(materialOrgVO.getCategoryId());
            MaterialOrgEntity entity = (MaterialOrgEntity)((Object)BeanMapper.map((Object)materialOrgVO, MaterialOrgEntity.class));
            entity.setId(null);
            entity.setCreateUserName(null);
            entity.setCreateUserCode(null);
            entity.setUpdateTime(null);
            entity.setUpdateUserCode(null);
            entity.setTenantId(null);
            super.saveOrUpdate((Object)entity, false);
            vo.add((MaterialOrgVO)BeanMapper.map((Object)((Object)entity), MaterialOrgVO.class));
        }
        return vo;
    }

    @Override
    public List<MaterialOrgVO> saveCategory(Long categoryId) {
        CommonResponse materialCategoryVOS = this.materialApi.queryCategoryListByPid(categoryId);
        if (CollectionUtils.isNotEmpty((Collection)((Collection)materialCategoryVOS.getData()))) {
            throw new BusinessException("\u8bf7\u5f15\u7528\u6700\u4e0b\u7ea7\u5206\u7c7b\uff01");
        }
        CommonResponse materialVOS = this.materialApi.queryMatListByLeafCtyId(categoryId);
        List materialOrgVOS = BeanMapper.mapList((Iterable)((Iterable)materialVOS.getData()), MaterialOrgVO.class);
        List<MaterialOrgVO> vo = this.service.saveOrUpdate(materialOrgVOS);
        return vo;
    }
}

