/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.storecloud.bean.ApplyEntity;
import com.ejianc.business.storecloud.bean.OutDetailEntity;
import com.ejianc.business.storecloud.bean.OutEntity;
import com.ejianc.business.storecloud.enums.InOutFlagEnum;
import com.ejianc.business.storecloud.enums.OutStatusEnum;
import com.ejianc.business.storecloud.service.IApplyService;
import com.ejianc.business.storecloud.service.IOutService;
import com.ejianc.business.storecloud.service.IWarehouseFlowService;
import com.ejianc.business.storecloud.vo.WarehouseFlowVO;
import com.ejianc.business.storecloud.vo.WarehouseManageVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="out")
public class OutBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IWarehouseFlowService warehouseFlowService;
    @Autowired
    private IOutService outService;
    @Autowired
    private IApplyService applyService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return this.writeBackAndPush(billId);
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.rollBack(billId);
    }

    private CommonResponse<String> writeBackAndPush(Long billId) {
        ArrayList<WarehouseFlowVO> warehouseFlowVOList = new ArrayList<WarehouseFlowVO>();
        OutEntity outEntity = (OutEntity)((Object)this.outService.selectById(billId));
        List<OutDetailEntity> outDetailEntityList = outEntity.getOutDetailEntityList();
        for (OutDetailEntity outDetailEntity : outDetailEntityList) {
            WarehouseFlowVO warehouseFlowVO = new WarehouseFlowVO();
            warehouseFlowVO.setBillCode(outEntity.getBillCode());
            warehouseFlowVO.setBillDate(outEntity.getCreateTime());
            warehouseFlowVO.setProjectId(outEntity.getProjectId());
            warehouseFlowVO.setProjectName(outEntity.getProjectName());
            warehouseFlowVO.setParentOrgId(outEntity.getOrgId());
            warehouseFlowVO.setParentOrgCode(outEntity.getOrgCode());
            warehouseFlowVO.setParentOrgName(outEntity.getOrgName());
            warehouseFlowVO.setStoreId(outEntity.getStoreId());
            warehouseFlowVO.setStoreName(outEntity.getStoreName());
            warehouseFlowVO.setEmployeeName(outEntity.getCreateUserCode());
            warehouseFlowVO.setSupplierId(Long.valueOf(outEntity.getSupplyId()));
            warehouseFlowVO.setSupplierName(outEntity.getSupplyName());
            warehouseFlowVO.setInOutType(outEntity.getCoseFlag());
            if (outEntity.getCoseFlag() == 3) {
                warehouseFlowVO.setInOutTypeName("\u9886\u6599\u51fa\u5e93");
            } else {
                warehouseFlowVO.setInOutTypeName("\u76f4\u63a5\u51fa\u5e93");
            }
            warehouseFlowVO.setInOutFlag(Integer.valueOf(2));
            warehouseFlowVO.setMaterialCategoryId(outDetailEntity.getMaterialCategoryId());
            warehouseFlowVO.setMaterialCategoryName(outDetailEntity.getMaterialCategoryName());
            warehouseFlowVO.setMaterialCategoryCode(outDetailEntity.getMaterialCategoryCode());
            warehouseFlowVO.setMaterialId(outDetailEntity.getMaterialId());
            warehouseFlowVO.setMaterialName(outDetailEntity.getMaterialName());
            warehouseFlowVO.setMaterialCode(outDetailEntity.getMaterialCode());
            warehouseFlowVO.setMaterialSpec(outDetailEntity.getMaterialSpec());
            warehouseFlowVO.setMaterialUnitName(outDetailEntity.getMaterialUnitName());
            warehouseFlowVO.setPrice(outDetailEntity.getSurplusPrice());
            warehouseFlowVO.setTaxPrice(outDetailEntity.getSurplusTaxPrice());
            warehouseFlowVO.setNum(outDetailEntity.getOutNumber());
            warehouseFlowVO.setMny(ComputeUtil.safeMultiply((BigDecimal)outDetailEntity.getOutNumber(), (BigDecimal)outDetailEntity.getSurplusPrice()));
            warehouseFlowVO.setTaxMny(ComputeUtil.safeMultiply((BigDecimal)outDetailEntity.getOutNumber(), (BigDecimal)outDetailEntity.getSurplusTaxPrice()));
            warehouseFlowVO.setSourceBillTypeCode("EJCBT202208000010");
            warehouseFlowVO.setSourceBillTypeName("\u5185\u90e8\u4eba\u5458\u9886\u6599\u51fa\u5e93");
            warehouseFlowVO.setSourceId(outEntity.getId());
            warehouseFlowVO.setSourceDetailId(outDetailEntity.getId());
            warehouseFlowVO.setSourceBillCode(outEntity.getBillCode());
            warehouseFlowVO.setSourceBillDate(outEntity.getCreateTime());
            warehouseFlowVOList.add(warehouseFlowVO);
        }
        for (WarehouseFlowVO warehouseFlowVO : warehouseFlowVOList) {
            this.logger.info("\u51fa\u5e93\u6d41\u6c34,sss---------->: {}", (Object)JSONObject.toJSONString((Object)warehouseFlowVO));
        }
        WarehouseManageVO manageVO = new WarehouseManageVO();
        manageVO.setProjectId(outEntity.getProjectId());
        manageVO.setStoreId(outEntity.getStoreId());
        manageVO.setInOutFlag(InOutFlagEnum.\u51fa\u5e93.getCode());
        manageVO.setFlowVOList(warehouseFlowVOList);
        CommonResponse<String> flag = this.warehouseFlowService.push(manageVO);
        if (flag != null && !flag.getMsg().equals("\u63d2\u5165\u6d41\u6c34\u6210\u529f")) {
            throw new BusinessException(flag.getMsg());
        }
        if (outEntity.getCoseFlag() == 3) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)outEntity.getApplyId());
            updateWrapper.set(ApplyEntity::getOutFlag, (Object)OutStatusEnum.\u5df2\u51fa\u5e93.getCode());
            boolean isFlag = this.applyService.update((Wrapper)updateWrapper);
            if (!isFlag) {
                throw new BusinessException("\u51fa\u5e93\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        return CommonResponse.success();
    }

    private CommonResponse<String> rollBack(Long billId) {
        OutEntity outEntity = (OutEntity)((Object)this.outService.selectById(billId));
        ArrayList<Long> ids = new ArrayList<Long>();
        for (OutDetailEntity outDetailEntity : outEntity.getOutDetailEntityList()) {
            ids.add(outDetailEntity.getId());
        }
        WarehouseManageVO manageVO = new WarehouseManageVO();
        manageVO.setProjectId(outEntity.getProjectId());
        manageVO.setStoreId(outEntity.getStoreId());
        manageVO.setInOutFlag(InOutFlagEnum.\u51fa\u5e93.getCode());
        manageVO.setDelDetailIdList(ids);
        this.warehouseFlowService.rollBack(manageVO);
        if (outEntity.getCoseFlag() == 3) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            updateWrapper.eq(BaseEntity::getId, (Object)outEntity.getApplyId());
            updateWrapper.set(ApplyEntity::getOutFlag, (Object)OutStatusEnum.\u5f85\u51fa\u5e93.getCode());
            boolean isFlag = this.applyService.update((Wrapper)updateWrapper);
            if (!isFlag) {
                throw new BusinessException("\u51fa\u5e93\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        return CommonResponse.success();
    }
}

