/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.storecloud.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.business.storecloud.bean.ApplyDetailEntity;
import com.ejianc.business.storecloud.bean.ApplyEntity;
import com.ejianc.business.storecloud.bean.OutDetailEntity;
import com.ejianc.business.storecloud.bean.OutEntity;
import com.ejianc.business.storecloud.bean.WarehouseSurplusEntity;
import com.ejianc.business.storecloud.enums.OutStatusEnum;
import com.ejianc.business.storecloud.mapper.OutMapper;
import com.ejianc.business.storecloud.service.IApplyService;
import com.ejianc.business.storecloud.service.IOutService;
import com.ejianc.business.storecloud.service.IWarehouseSurplusService;
import com.ejianc.business.storecloud.vo.ApplyVO;
import com.ejianc.business.storecloud.vo.OutVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outService")
public class OutServiceImpl
extends BaseServiceImpl<OutMapper, OutEntity>
implements IOutService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IApplyService applyService;
    @Autowired
    private IWarehouseSurplusService warehouseSurplusService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IProjectApi iProjectApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "LING_LIAO";

    @Override
    public OutVO saveUpdate(OutVO saveOrUpdateVO) {
        OutEntity entity = (OutEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), OutEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            entity.setTenantId(InvocationInfoProxy.getTenantid());
            ArrayList<Long> projectId = new ArrayList<Long>();
            projectId.add(entity.getProjectId());
            CommonResponse projectRegisterVO = this.iProjectApi.queryProjectByIds(projectId);
            if (projectRegisterVO.getCode() == 0 && projectRegisterVO.getData() != null) {
                ProjectRegisterVO registerVO = (ProjectRegisterVO)((List)projectRegisterVO.getData()).get(0);
                entity.setOrgId(registerVO.getProjectDepartmentId());
                entity.setRealCorpId(registerVO.getRealCorpId());
                entity.setRealCorpName(registerVO.getRealCorpName());
                CommonResponse orgVo = this.iOrgApi.detailById(entity.getOrgId());
                entity.setOrgCode(((OrgVO)orgVo.getData()).getCode());
                entity.setOrgName(((OrgVO)orgVo.getData()).getName());
                if (((OrgVO)orgVo.getData()).getParentId() != null) {
                    entity.setParentOrgId(((OrgVO)orgVo.getData()).getParentId());
                } else {
                    entity.setParentOrgId(entity.getOrgId());
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u672a\u83b7\u53d6\u5230\u9879\u76ee\u90e8\u4e3b\u952e");
            }
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        BigDecimal outTaxMny = new BigDecimal(0);
        BigDecimal outMny = new BigDecimal(0);
        for (OutDetailEntity outDetailEntity : entity.getOutDetailEntityList()) {
            outDetailEntity.setOutMny(ComputeUtil.safeMultiply((BigDecimal)outDetailEntity.getOutNumber(), (BigDecimal)outDetailEntity.getSurplusPrice()));
            outTaxMny = ComputeUtil.safeAdd((BigDecimal)outTaxMny, (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)outDetailEntity.getOutNumber(), (BigDecimal)outDetailEntity.getSurplusTaxPrice()));
            outMny = ComputeUtil.safeAdd((BigDecimal)outMny, (BigDecimal)ComputeUtil.safeMultiply((BigDecimal)outDetailEntity.getOutNumber(), (BigDecimal)outDetailEntity.getSurplusPrice()));
        }
        entity.setOutMny(outMny);
        entity.setOutTaxMny(outTaxMny);
        entity.setSupplyName("\u4e2d\u5efa\u4e94\u5c40");
        entity.setSupplyId("1328246322863542273");
        this.saveOrUpdate((Object)entity, false);
        OutVO vo = (OutVO)((Object)BeanMapper.map((Object)((Object)entity), OutVO.class));
        return vo;
    }

    @Override
    public OutVO scanOut(Long id) {
        ApplyEntity applyEntity = (ApplyEntity)((Object)this.applyService.selectById(id));
        if (!OutStatusEnum.\u5f85\u51fa\u5e93.getCode().equals(applyEntity.getOutFlag())) {
            throw new BusinessException("\u8be5\u7533\u8bf7\u5355\u5df2\u51fa\u5e93\u6216\u5df2\u5931\u6548\uff01");
        }
        OutVO outVO = new OutVO();
        if (applyEntity != null) {
            ApplyVO applyVO = (ApplyVO)((Object)BeanMapper.map((Object)((Object)applyEntity), ApplyVO.class));
            outVO = (OutVO)((Object)BeanMapper.map((Object)((Object)applyVO), OutVO.class));
            outVO.setId(null);
            outVO.setCreateTime(null);
            outVO.setUpdateTime(null);
            outVO.setBillCode(null);
            outVO.setCreateUserCode(null);
            outVO.setVersion(1);
            outVO.setStoreName(applyEntity.getStoreName());
            outVO.setApplyForDate(applyVO.getApplyForDate());
            outVO.setStoreId(applyVO.getStoreId());
            outVO.setStoreName(applyVO.getStoreName());
            outVO.setProjectId(applyVO.getProjectId());
            outVO.setProjectName(applyVO.getProjectName());
            outVO.setApplyId(applyVO.getId());
            outVO.setMoney(applyVO.getMoney());
            outVO.setMemo(applyVO.getMemo());
            outVO.setRedirectNcFlag(applyVO.getRedirectNcFlag());
            outVO.setBillState(null);
            List<ApplyDetailEntity> applyDetailEntityList = applyEntity.getApplyDetailEntityList();
            ArrayList<OutDetailEntity> outDetailEntityList = new ArrayList<OutDetailEntity>();
            for (ApplyDetailEntity applyDetailEntity : applyDetailEntityList) {
                OutDetailEntity outDetailEntity = (OutDetailEntity)((Object)BeanMapper.map((Object)((Object)applyDetailEntity), OutDetailEntity.class));
                outDetailEntity.setOutId(null);
                outDetailEntity.setOutNumber(applyDetailEntity.getApplyNumber());
                outDetailEntity.setApplyNumber(applyDetailEntity.getApplyNumber());
                outDetailEntity.setApplyDetailId(applyDetailEntity.getId());
                outDetailEntity.setId(null);
                outDetailEntity.setMemo(null);
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(WarehouseSurplusEntity::getMaterialId, (Object)applyDetailEntity.getMaterialId());
                queryWrapper.eq(WarehouseSurplusEntity::getStoreId, (Object)applyEntity.getStoreId());
                WarehouseSurplusEntity warehouseSurplusEntity = (WarehouseSurplusEntity)((Object)this.warehouseSurplusService.getOne((Wrapper)queryWrapper));
                if (warehouseSurplusEntity != null) {
                    outDetailEntity.setSurplusNum(warehouseSurplusEntity.getSurplusNum());
                    outDetailEntity.setSurplusPrice(warehouseSurplusEntity.getSurplusPrice());
                    outDetailEntity.setSurplusTaxPrice(warehouseSurplusEntity.getSurplusTaxPrice());
                    outDetailEntity.setSurplusMny(warehouseSurplusEntity.getSurplusMny());
                    outDetailEntity.setSurplusTaxMny(warehouseSurplusEntity.getSurplusTaxMny());
                }
                outDetailEntityList.add(outDetailEntity);
            }
            outVO.setOutDetailEntityList(outDetailEntityList);
        } else {
            this.logger.info("----------------\u626b\u7801\u51fa\u5e93\u8df3\u8f6c\u8be6\u60c5outVO\u67e5\u8be2\u6570\u636e\u4e3a\u7a7a------------------");
        }
        return outVO;
    }
}

